/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.api.ItemStorage;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.network.messages.FillTopPlaceholderMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowScan
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowscantool.xml";
    private static final String CHEST_WARNING = "chestwarning";
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final Object2IntMap<EntityType<?>> entities = new Object2IntOpenHashMap();
    public static final int WHITE = Color.getByName((String)"white", (int)0);
    private ScanToolData data;
    private String filter = "";
    private final TextField pos1x;
    private final TextField pos1y;
    private final TextField pos1z;
    private final TextField pos2x;
    private final TextField pos2y;
    private final TextField pos2z;
    private final TextField slotId;
    private final ScrollingList resourceList;
    private final ScrollingList entityList;
    private boolean replacing;

    public WindowScan(@NotNull ScanToolData data) {
        super("structurize:gui/windowscantool.xml");
        this.data = data;
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::discardClicked);
        this.registerButton("showRes", this::showResClicked);
        this.registerButton("removeEntity", this::removeEntity);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("replaceBlock", this::replaceBlock);
        this.registerButton("fillplaceholders", this::showFillplaceholderUI);
        this.registerButton("cancelfill", this::cancelFill);
        this.registerButton("fill", this::fillPlaceholders);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.registerButton("removefiltered", this::removeFilteredBlock);
        this.pos1x = (TextField)this.findPaneOfTypeByID("pos1x", TextField.class);
        this.pos1y = (TextField)this.findPaneOfTypeByID("pos1y", TextField.class);
        this.pos1z = (TextField)this.findPaneOfTypeByID("pos1z", TextField.class);
        this.pos2x = (TextField)this.findPaneOfTypeByID("pos2x", TextField.class);
        this.pos2y = (TextField)this.findPaneOfTypeByID("pos2y", TextField.class);
        this.pos2z = (TextField)this.findPaneOfTypeByID("pos2z", TextField.class);
        this.slotId = (TextField)this.findPaneOfTypeByID("slot", TextField.class);
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.entityList = (ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class);
    }

    private void showFillplaceholderUI() {
        ((View)this.findPaneOfTypeByID("fillplaceholdersui", View.class)).setVisible(true);
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setVisible(false);
        ((ButtonImage)this.findPaneOfTypeByID("fillplaceholders", ButtonImage.class)).setVisible(false);
    }

    private void cancelFill() {
        ((View)this.findPaneOfTypeByID("fillplaceholdersui", View.class)).setVisible(false);
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setVisible(true);
        ((ButtonImage)this.findPaneOfTypeByID("fillplaceholders", ButtonImage.class)).setVisible(true);
    }

    private void fillPlaceholders() {
        try {
            double yStretch = Double.parseDouble(((TextField)this.findPaneOfTypeByID("ystretch", TextField.class)).getText());
            double circleRadiusMult = Double.parseDouble(((TextField)this.findPaneOfTypeByID("radius", TextField.class)).getText());
            int heightOffset = Integer.parseInt(((TextField)this.findPaneOfTypeByID("heightoffset", TextField.class)).getText());
            int minDistToBlocks = Integer.parseInt(((TextField)this.findPaneOfTypeByID("blockdist", TextField.class)).getText());
            new FillTopPlaceholderMessage(this.data.currentSlot().box().pos1(), this.data.currentSlot().box().pos2(), yStretch, circleRadiusMult, heightOffset, minDistToBlocks).sendToServer();
        }
        catch (Exception e) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Invalid Number"), false);
        }
        this.close();
    }

    private void showResClicked() {
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).show();
        ((Button)this.findPaneOfTypeByID("showRes", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("removefiltered", Button.class)).show();
        this.updateResources();
    }

    private void removeEntity(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.entityList.getListElementIndexByPane((Pane)button);
        EntityType entity = (EntityType)new ArrayList(this.entities.keySet()).get(row);
        new RemoveEntityMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), EntityType.getKey((EntityType)entity)).sendToServer();
        this.entities.removeInt((Object)entity);
        this.updateEntitylist();
    }

    private void removeBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        ItemStack stack = ((ItemStorage)tempRes.get(row)).getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        new RemoveBlockMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), stack).sendToServer();
        int hashCode = stack.getComponents().isEmpty() ? 0 : stack.getComponents().hashCode();
        this.resources.remove(stack.getDescriptionId() + ":" + stack.getDamageValue() + "-" + hashCode);
        this.updateResourceList();
    }

    private void removeFilteredBlock() {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        ArrayList<ItemStack> blocks = new ArrayList<ItemStack>();
        for (ItemStorage tempRes : new ArrayList<ItemStorage>(this.resources.values())) {
            ItemStack stack = tempRes.getItemStack();
            if (stack.isEmpty()) continue;
            blocks.add(stack);
            int hashCode = stack.getComponents().isEmpty() ? 0 : stack.getComponents().hashCode();
            this.resources.remove(stack.getDescriptionId() + ":" + stack.getDamageValue() + "-" + hashCode);
        }
        new RemoveBlockMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), blocks).sendToServer();
        this.updateResourceList();
    }

    private void replaceBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        new WindowReplaceBlock(((ItemStorage)tempRes.get(row)).getItemStack(), new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), (BOWindow)this).open();
        this.replacing = true;
    }

    public void onOpened() {
        super.onOpened();
        if (!Minecraft.getInstance().player.isCreative()) {
            this.pos1x.disable();
            this.pos1y.disable();
            this.pos1z.disable();
            this.pos2x.disable();
            this.pos2y.disable();
            this.pos2z.disable();
        }
        this.loadSlot();
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).setHandler(input -> {
            this.filter = ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).getText();
            this.updateResources();
        });
    }

    public void onClosed() {
        if (RenderingCache.getBoxPreviewData("scan") != null) {
            this.updateBounds();
        }
        super.onClosed();
    }

    public void onUpdate() {
        if (this.replacing) {
            this.updateResources();
            this.replacing = false;
        }
        super.onUpdate();
    }

    private void discardClicked() {
        RenderingCache.removeBox("scan");
        this.close();
    }

    private void confirmClicked() {
        this.updateBounds();
        new ScanOnServerMessage(this.data.currentSlot(), true).sendToServer();
        RenderingCache.removeBox("scan");
        this.close();
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (ch >= 48 && ch <= 57) {
            this.updateBounds();
            this.data = this.data.moveTo(ch - 48);
            this.loadSlot();
            this.updateResources();
            return true;
        }
        return super.onUnhandledKeyTyped(ch, key);
    }

    private void loadSlot() {
        BlockEntity tile;
        this.slotId.setText(String.valueOf(this.data.currentSlotId()));
        ScanToolData.Slot slot = this.data.currentSlot();
        this.pos1x.setText(String.valueOf(slot.box().pos1().getX()));
        this.pos1y.setText(String.valueOf(slot.box().pos1().getY()));
        this.pos1z.setText(String.valueOf(slot.box().pos1().getZ()));
        this.pos2x.setText(String.valueOf(slot.box().pos2().getX()));
        this.pos2y.setText(String.valueOf(slot.box().pos2().getY()));
        this.pos2z.setText(String.valueOf(slot.box().pos2().getZ()));
        RenderingCache.queue("scan", slot.box());
        ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText("");
        if (!slot.name().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(slot.name());
        } else if (slot.box().anchor().isPresent() && (tile = Minecraft.getInstance().player.level().getBlockEntity(slot.box().anchor().get())) instanceof IBlueprintDataProviderBE && !((IBlueprintDataProviderBE)tile).getSchematicName().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(((IBlueprintDataProviderBE)tile).getSchematicName());
        }
    }

    private void updateBounds() {
        BlockPos pos2;
        BlockPos pos1;
        BlockPos def = Minecraft.getInstance().player.blockPosition();
        try {
            int x1 = this.pos1x.getText().isEmpty() ? def.getX() : Integer.parseInt(this.pos1x.getText());
            int y1 = this.pos1y.getText().isEmpty() ? def.getY() : Integer.parseInt(this.pos1y.getText());
            int z1 = this.pos1z.getText().isEmpty() ? def.getZ() : Integer.parseInt(this.pos1z.getText());
            pos1 = new BlockPos(x1, y1, z1);
            int x2 = this.pos2x.getText().isEmpty() ? def.getX() : Integer.parseInt(this.pos2x.getText());
            int y2 = this.pos2y.getText().isEmpty() ? def.getY() : Integer.parseInt(this.pos2y.getText());
            int z2 = this.pos2z.getText().isEmpty() ? def.getZ() : Integer.parseInt(this.pos2z.getText());
            pos2 = new BlockPos(x2, y2, z2);
        }
        catch (NumberFormatException e) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Invalid Number"), false);
            return;
        }
        String name = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
        this.data = this.data.withCurrentSlot(new ScanToolData.Slot(name, this.data.currentSlot().box().withCorners(pos1, pos2)));
        RenderingCache.queue("scan", this.data.currentSlot().box());
        new UpdateScanToolMessage(this.data).sendToServer();
    }

    private void updateResources() {
        this.updateBounds();
        ClientLevel world = Minecraft.getInstance().level;
        this.resources.clear();
        this.entities.clear();
        if (this.findPaneByID("showRes").isVisible()) {
            return;
        }
        BoxPreviewData box = this.data.currentSlot().box();
        List list = world.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks((BlockPos)box.pos1(), (BlockPos)box.pos2()));
        for (Entity entity : list) {
            if (this.entities.containsKey((Object)entity.getType()) || !entity.getType().canSerialize() && !entity.getType().equals(EntityType.LEASH_KNOT) || !this.filter.isEmpty() && !entity.getName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !entity.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
            this.entities.mergeInt((Object)entity.getType(), 1, Integer::sum);
        }
        for (BlockPos here : BlockPos.betweenClosed((BlockPos)box.pos1(), (BlockPos)box.pos2())) {
            BlockState blockState = world.getBlockState(here);
            BlockEntity tileEntity = world.getBlockEntity(here);
            @Nullable Block block = blockState.getBlock();
            if (block == Blocks.AIR || block == Blocks.VOID_AIR || block == Blocks.CAVE_AIR) {
                this.addNeededResource(new ItemStack((ItemLike)Blocks.AIR, 1), 1);
                continue;
            }
            IPlacementHandler handler = PlacementHandlers.getHandler((Level)world, here, blockState);
            List<ItemStack> itemList = handler.getRequiredItems((Level)world, here, blockState, tileEntity == null ? null : tileEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess()), true);
            for (ItemStack stack : itemList) {
                this.addNeededResource(stack, 1);
            }
        }
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
        this.updateEntitylist();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res == null || amount == 0) {
            return;
        }
        int hashCode = res.getComponents().isEmpty() ? 0 : res.getComponents().hashCode();
        ItemStorage resource = this.resources.get(res.getDescriptionId() + ":" + res.getDamageValue() + "-" + hashCode);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        if (this.filter.isEmpty() || res.getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) {
            this.resources.put(res.getDescriptionId() + ":" + res.getDamageValue() + "-" + hashCode, resource);
        }
    }

    public void updateEntitylist() {
        this.entityList.enable();
        this.entityList.show();
        final ArrayList tempEntities = new ArrayList(this.entities.keySet());
        this.entityList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempEntities.size();
            }

            public void updateElement(int index, Pane rowPane) {
                EntityType entity = (EntityType)tempEntities.get(index);
                ItemStack entityIcon = entity.create((Level)Minecraft.getInstance().level).getPickResult();
                if (entity == EntityType.GLOW_ITEM_FRAME) {
                    entityIcon = new ItemStack((ItemLike)Items.GLOW_ITEM_FRAME);
                } else if (entity == EntityType.ITEM_FRAME) {
                    entityIcon = new ItemStack((ItemLike)Items.ITEM_FRAME);
                } else if (entity == EntityType.MINECART) {
                    entityIcon = new ItemStack((ItemLike)Items.MINECART);
                }
                ((Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Component.literal((String)Integer.toString(WindowScan.this.entities.getInt((Object)entity))));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(entityIcon);
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(entity.getDescription());
                if (!Minecraft.getInstance().player.isCreative()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeEntity", Button.class)).hide();
                }
            }
        });
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        ((Text)this.window.findPaneOfTypeByID(CHEST_WARNING, Text.class)).show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().getHoverName());
                quantityLabel.setText(Component.literal((String)Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack copy = resource.getItemStack().copy();
                copy.setCount(1);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(copy);
                if (!Minecraft.getInstance().player.isCreative()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeBlock", Button.class)).hide();
                    ((Button)rowPane.findPaneOfTypeByID("replaceBlock", Button.class)).hide();
                }
            }
        });
    }
}

