/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.RemoveEntityOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RemoveEntityMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"remove_entity", RemoveEntityMessage::new);
    private final BlockPos from;
    private final BlockPos to;
    private final ResourceLocation entityName;

    protected RemoveEntityMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.from = buf.readBlockPos();
        this.to = buf.readBlockPos();
        this.entityName = buf.readResourceLocation();
    }

    public RemoveEntityMessage(BlockPos pos1, BlockPos pos2, ResourceLocation entityName) {
        super(TYPE);
        this.from = pos1;
        this.to = pos2;
        this.entityName = entityName;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.from);
        buf.writeBlockPos(this.to);
        buf.writeResourceLocation(this.entityName);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.entityName);
        if (type != null) {
            Manager.addToQueue(new RemoveEntityOperation((Player)player, this.from, this.to, type));
        }
    }
}

