/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.api.BlockPosUtil;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class BlueprintIteratorInwardCircleHeight
extends AbstractBlueprintIterator {
    private final BlockPos topRightCorner;
    private final int height;

    public BlueprintIteratorInwardCircleHeight(IStructureHandler structureHandler, int height) {
        super(structureHandler);
        this.topRightCorner = this.size.offset(-1, -1, -1);
        this.height = height;
    }

    @Override
    public AbstractBlueprintIterator.Result increment() {
        this.prevProgressPos.set((Vec3i)this.progressPos);
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.set(0, 0, 0);
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        BlockPos next = BlockPosUtil.getNextPosInCircleFrom((BlockPos)this.progressPos, BlockPos.ZERO, this.topRightCorner, this.height);
        if (next.equals((Object)this.progressPos)) {
            this.reset();
            return AbstractBlueprintIterator.Result.AT_END;
        }
        this.progressPos.set((Vec3i)next);
        return AbstractBlueprintIterator.Result.NEW_BLOCK;
    }

    @Override
    public AbstractBlueprintIterator.Result decrement() {
        this.prevProgressPos.set((Vec3i)this.progressPos);
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.set(0, this.topRightCorner.getY(), 0);
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        this.progressPos.setY(this.topRightCorner.getY() - this.progressPos.getY());
        BlockPos next = BlockPosUtil.getNextPosInCircleFrom((BlockPos)this.progressPos, BlockPos.ZERO, this.topRightCorner, 1);
        if (next == this.progressPos) {
            this.reset();
            return AbstractBlueprintIterator.Result.AT_END;
        }
        this.progressPos.set(next.getX(), this.topRightCorner.getY() - next.getY(), next.getZ());
        return AbstractBlueprintIterator.Result.NEW_BLOCK;
    }
}

