/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ScanToolData(List<Slot> slots, int currentSlotId, @Nullable BlockPos commandPos, @Nullable ResourceKey<Level> dimension) {
    public static final int NUM_SLOTS = 10;
    public static final Codec<ScanToolData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Slot.CODEC.listOf().fieldOf("slots").forGetter(data -> data.slots), (App)Codec.intRange((int)0, (int)9).fieldOf("current_slot").forGetter(ScanToolData::currentSlotId), (App)BlockPos.CODEC.optionalFieldOf("commands_pos").forGetter(data -> Optional.ofNullable(data.commandPos)), (App)Level.RESOURCE_KEY_CODEC.optionalFieldOf("dimension_key").forGetter(data -> Optional.ofNullable(data.dimension))).apply((Applicative)builder, ScanToolData::fromCodec));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScanToolData> STREAM_CODEC = StreamCodec.composite((StreamCodec)Slot.STREAM_CODEC.apply(ByteBufCodecs.list()), data -> data.slots, (StreamCodec)ByteBufCodecs.VAR_INT, ScanToolData::currentSlotId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), data -> Optional.ofNullable(data.commandPos), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION)), data -> Optional.ofNullable(data.dimension), ScanToolData::fromCodec);
    public static ScanToolData EMPTY = new ScanToolData(List.of(), 1, null, null);

    public ScanToolData(List<Slot> slots, int currentSlotId, @Nullable BlockPos commandPos, @Nullable ResourceKey<Level> dimension) {
        ArrayList<Slot> newSlots = new ArrayList<Slot>(slots);
        while (newSlots.size() > 10 || !newSlots.isEmpty() && ((Slot)newSlots.getLast()).equals(Slot.EMPTY)) {
            newSlots.removeLast();
        }
        this.slots = Collections.unmodifiableList(newSlots);
        this.currentSlotId = currentSlotId;
        this.commandPos = commandPos;
        this.dimension = dimension;
    }

    private static ScanToolData fromCodec(List<Slot> slots, int currentSlotId, Optional<BlockPos> commandPos, Optional<ResourceKey<Level>> dimension) {
        return new ScanToolData(slots, currentSlotId, commandPos.orElse(null), (ResourceKey<Level>)((ResourceKey)dimension.orElse(null)));
    }

    public Slot currentSlot() {
        return this.currentSlotId < this.slots.size() ? this.slots.get(this.currentSlotId) : Slot.EMPTY;
    }

    public ScanToolData withCurrentSlot(@Nullable Slot data) {
        ArrayList<Slot> newSlots = new ArrayList<Slot>(this.slots);
        while (this.currentSlotId >= newSlots.size()) {
            newSlots.add(Slot.EMPTY);
        }
        newSlots.set(this.currentSlotId, data == null ? Slot.EMPTY : data);
        return new ScanToolData(newSlots, this.currentSlotId, this.commandPos, this.dimension);
    }

    public ScanToolData nextSlot() {
        return this.moveTo((this.currentSlotId() + 1) % 10);
    }

    public ScanToolData prevSlot() {
        return this.moveTo((this.currentSlotId() + 10 - 1) % 10);
    }

    public ScanToolData moveTo(int slot) {
        return new ScanToolData(this.slots, slot, this.commandPos, this.dimension);
    }

    public ScanToolData withCommandBlock(@Nullable CommandBlockEntity commandBlock) {
        return commandBlock == null ? new ScanToolData(this.slots, this.currentSlotId, null, null) : new ScanToolData(this.slots, this.currentSlotId, commandBlock.getBlockPos(), (ResourceKey<Level>)commandBlock.getLevel().dimension());
    }

    public static ScanToolData readFromItemStack(ItemStack stack) {
        return (ScanToolData)stack.getOrDefault(ModDataComponents.SCAN_TOOL, (Object)EMPTY);
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.SCAN_TOOL, (Object)this);
    }

    public static ScanToolData updateItemStack(ItemStack stack, UnaryOperator<ScanToolData> updater) {
        ScanToolData data = (ScanToolData)updater.apply(ScanToolData.readFromItemStack(stack));
        data.writeToItemStack(stack);
        return data;
    }

    public record Slot(@NotNull String name, @NotNull BoxPreviewData box) {
        public static final Slot EMPTY = new Slot("", new BoxPreviewData(BlockPos.ZERO, BlockPos.ZERO, Optional.empty()));
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(Slot::name), (App)BoxPreviewData.CODEC.fieldOf("box").forGetter(Slot::box)).apply((Applicative)builder, Slot::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Slot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Slot::name, BoxPreviewData.STREAM_CODEC, Slot::box, Slot::new);

        public Slot withName(String name) {
            return new Slot(name, this.box);
        }

        public Slot withBox(BoxPreviewData box) {
            return new Slot(this.name, box);
        }
    }
}

