/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
@ReturnsSelf
public interface ComponentFunctions {
    default public DataComponentMap kjs$getComponentMap() {
        return DataComponentMap.EMPTY;
    }

    @Nullable
    default public <T> T kjs$get(DataComponentType<T> type) {
        return (T)this.kjs$getComponentMap().get(type);
    }

    @HideFromJS
    public <T> ComponentFunctions kjs$override(DataComponentType<T> var1, @Nullable T var2);

    default public ComponentFunctions kjs$set(Context cx, DataComponentType<?> component, Object value) {
        if (value == null || Undefined.isUndefined((Object)value)) {
            return this.kjs$remove(component);
        }
        return this.kjs$override(component, cx.jsToJava(value, DataComponentWrapper.getTypeInfo(component)));
    }

    default public ComponentFunctions kjs$remove(DataComponentType<?> type) {
        return this.kjs$override(type, null);
    }

    default public ComponentFunctions kjs$setUnit(DataComponentType<Unit> component) {
        return this.kjs$override(component, Unit.INSTANCE);
    }

    default public ComponentFunctions kjs$set(Context cx, DataComponentMap components) {
        components.forEach(c -> this.kjs$override(c.type(), Cast.to(c.value())));
        return this;
    }

    default public ComponentFunctions kjs$patch(Context cx, DataComponentPatch components) {
        for (Map.Entry entry : components.entrySet()) {
            this.kjs$override((DataComponentType)entry.getKey(), Cast.to(((Optional)entry.getValue()).orElse(null)));
        }
        return this;
    }

    default public ComponentFunctions kjs$resetComponents(Context cx) {
        DataComponentMap dataComponentMap = this.kjs$getComponentMap();
        if (dataComponentMap instanceof PatchedDataComponentMap) {
            PatchedDataComponentMap map = (PatchedDataComponentMap)dataComponentMap;
            map.restorePatch(DataComponentPatch.EMPTY);
        }
        return this;
    }

    default public String kjs$getComponentString(Context cx) {
        DataComponentMap dataComponentMap = this.kjs$getComponentMap();
        if (dataComponentMap instanceof PatchedDataComponentMap) {
            PatchedDataComponentMap map = (PatchedDataComponentMap)dataComponentMap;
            return DataComponentWrapper.patchToString(new StringBuilder(), RegistryAccessContainer.of(cx).nbt(), map.asPatch()).toString();
        }
        return "[]";
    }

    default public void kjs$setCustomData(CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            this.kjs$remove(DataComponents.CUSTOM_DATA);
        } else {
            this.kjs$override(DataComponents.CUSTOM_DATA, CustomData.of((CompoundTag)tag));
        }
    }

    default public CompoundTag kjs$getCustomData() {
        CustomData d = (CustomData)this.kjs$get(DataComponents.CUSTOM_DATA);
        return d == null ? new CompoundTag() : d.copyTag();
    }

    default public void kjs$setRarity(Rarity rarity) {
        this.kjs$override(DataComponents.RARITY, rarity);
    }

    default public void kjs$setCustomName(@Nullable Component name) {
        if (name != null) {
            this.kjs$override(DataComponents.CUSTOM_NAME, name);
        } else {
            this.kjs$remove(DataComponents.CUSTOM_NAME);
        }
    }

    @Nullable
    default public Component kjs$getCustomName() {
        return (Component)this.kjs$get(DataComponents.CUSTOM_NAME);
    }

    default public void kjs$setLore(List<Component> lines) {
        this.kjs$override(DataComponents.LORE, new ItemLore(List.copyOf(lines)));
    }

    default public void kjs$setLore(List<Component> lines, List<Component> styledLines) {
        this.kjs$override(DataComponents.LORE, new ItemLore(List.copyOf(lines), List.copyOf(styledLines)));
    }

    default public void kjs$setCustomModelData(int data) {
        this.kjs$override(DataComponents.CUSTOM_MODEL_DATA, new CustomModelData(data));
    }

    default public void kjs$setAdditionalTooltipHidden() {
        this.kjs$setUnit((DataComponentType<Unit>)DataComponents.HIDE_ADDITIONAL_TOOLTIP);
    }

    default public void kjs$setTooltipHidden() {
        this.kjs$setUnit((DataComponentType<Unit>)DataComponents.HIDE_TOOLTIP);
    }

    default public void kjs$setGlintOverride(boolean override) {
        this.kjs$override(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, override);
    }

    default public void kjs$setDyedColor(KubeColor color) {
        this.kjs$override(DataComponents.DYED_COLOR, new DyedItemColor(color.kjs$getRGB(), false));
    }

    default public void kjs$setDyedColorWithTooltip(KubeColor color) {
        this.kjs$override(DataComponents.DYED_COLOR, new DyedItemColor(color.kjs$getRGB(), true));
    }

    default public void kjs$setPotionContents(PotionContents contents) {
        this.kjs$override(DataComponents.POTION_CONTENTS, contents);
    }

    default public void kjs$setPotionId(Holder<Potion> potion) {
        this.kjs$override(DataComponents.POTION_CONTENTS, new PotionContents(potion));
    }

    default public void kjs$setEntityData(CompoundTag tag) {
        this.kjs$override(DataComponents.ENTITY_DATA, CustomData.of((CompoundTag)tag));
    }

    default public void kjs$setProfile(GameProfile profile) {
        this.kjs$override(DataComponents.PROFILE, new ResolvableProfile(profile));
    }

    default public void kjs$setProfile(@Nullable String name, @Nullable UUID uuid) {
        this.kjs$override(DataComponents.PROFILE, new ResolvableProfile(Optional.ofNullable(name != null && name.isBlank() ? null : name), Optional.ofNullable(uuid != null && uuid.getLeastSignificantBits() == 0L && uuid.getMostSignificantBits() == 0L ? null : uuid), new PropertyMap()));
    }

    default public void kjs$setBaseColor(DyeColor color) {
        this.kjs$override(DataComponents.BASE_COLOR, color);
    }

    default public void kjs$setBlockStateProperties(Map<String, String> properties) {
        this.kjs$override(DataComponents.BLOCK_STATE, new BlockItemStateProperties(properties));
    }

    default public void kjs$setLockCode(String lock) {
        this.kjs$override(DataComponents.LOCK, new LockCode(lock));
    }

    default public void kjs$setContainerLootTable(ResourceKey<LootTable> lootTable) {
        this.kjs$override(DataComponents.CONTAINER_LOOT, new SeededContainerLoot(lootTable, 0L));
    }

    default public void kjs$setContainerLootTable(ResourceKey<LootTable> lootTable, long seed) {
        this.kjs$override(DataComponents.CONTAINER_LOOT, new SeededContainerLoot(lootTable, seed));
    }
}

