/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import java.lang.runtime.SwitchBootstraps;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface AABBWrapper {
    public static final AABB EMPTY = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB CUBE = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public static AABB of(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AABB(x0, y0, z0, x1, y1, z1);
    }

    public static AABB ofBlocks(BlockPos pos1, BlockPos pos2) {
        return AABBWrapper.of(pos1.getX(), pos1.getY(), pos1.getZ(), (double)pos2.getX() + 1.0, (double)pos2.getY() + 1.0, (double)pos2.getZ() + 1.0);
    }

    public static AABB ofBlock(BlockPos pos) {
        return AABBWrapper.ofBlocks(pos, pos);
    }

    public static AABB ofSize(double x, double y, double z) {
        return AABBWrapper.ofSize(Vec3.ZERO, x, y, z);
    }

    public static AABB ofSize(Vec3 vec3, double x, double y, double z) {
        return AABB.ofSize((Vec3)vec3, (double)x, (double)y, (double)z);
    }

    public static AABB wrap(Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AABB.class, BlockPos.class, double[].class}, (Object)object, n)) {
            case 0 -> {
                AABB aabb;
                yield aabb = (AABB)object;
            }
            case 1 -> {
                BlockPos blockPos = (BlockPos)object;
                yield AABBWrapper.ofBlock(blockPos);
            }
            case 2 -> {
                double[] d = (double[])object;
                switch (d.length) {
                    case 3: {
                        yield AABBWrapper.ofSize(d[0], d[1], d[2]);
                    }
                    case 6: {
                        yield AABBWrapper.of(d[0], d[1], d[2], d[3], d[4], d[5]);
                    }
                }
                yield EMPTY;
            }
            default -> EMPTY;
        };
    }
}

