/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientComponent(RecipeComponentType<?> type, Codec<Ingredient> codec, boolean allowEmpty) implements RecipeComponent<Ingredient>
{
    public static final RecipeComponentType<Ingredient> INGREDIENT = RecipeComponentType.unit(KubeJS.id("ingredient"), type -> new IngredientComponent((RecipeComponentType<?>)type, (Codec<Ingredient>)Ingredient.CODEC_NONEMPTY, false));
    public static final RecipeComponentType<Ingredient> OPTIONAL_INGREDIENT = RecipeComponentType.unit(KubeJS.id("optional_ingredient"), type -> new IngredientComponent((RecipeComponentType<?>)type, (Codec<Ingredient>)Ingredient.CODEC, true));

    @Override
    public TypeInfo typeInfo() {
        return IngredientWrapper.TYPE_INFO;
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return IngredientWrapper.isIngredientLike(from);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(RecipeMatchContext cx, Ingredient value, ReplacementMatchInfo match) {
        ReplacementMatch replacementMatch = match.match();
        if (!(replacementMatch instanceof ItemMatch)) return false;
        ItemMatch m = (ItemMatch)replacementMatch;
        if (value.isEmpty()) return false;
        if (!m.matches(cx, value, match.exact())) return false;
        return true;
    }

    @Override
    public boolean isEmpty(Ingredient value) {
        if (value.isEmpty()) {
            return true;
        }
        ItemStack[] stacks = value.getItems();
        if (stacks.length == 0) {
            return true;
        }
        int count = 0;
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || stack.getItem() == Items.BARRIER) continue;
            ++count;
        }
        return count == 0;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Ingredient value) {
        TagKey<Item> tag = IngredientWrapper.tagKeyOf(value);
        if (tag != null) {
            builder.append(tag.location());
        } else {
            ItemStack first = value.kjs$getFirst();
            if (!first.isEmpty()) {
                builder.append(first.kjs$getIdLocation());
            }
        }
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toString(OpsContainer ops, Ingredient value) {
        return value.kjs$toIngredientString(ops.nbt());
    }
}

