/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.RegistryAwareSchema;
import java.util.LinkedHashMap;
import net.minecraft.resources.ResourceLocation;

public class RecipeNamespace
extends LinkedHashMap<String, RecipeSchemaType> {
    public final RecipeSchemaStorage storage;
    public final String name;

    public RecipeNamespace(RecipeSchemaStorage storage, String name) {
        this.storage = storage;
        this.name = name;
    }

    public RecipeNamespace register(String id, RecipeSchema type) {
        this.put(id, new RecipeSchemaType(this, ResourceLocation.fromNamespaceAndPath((String)this.name, (String)id), type));
        return this;
    }

    public RecipeNamespace register(String id, RegistryAwareSchema type) {
        return this.register(id, type.create(this.storage.getRegistries()));
    }

    public RecipeNamespace registerBasic(String id, RecipeKey<?> ... keys) {
        return this.register(id, new RecipeSchema(keys));
    }

    public RecipeNamespace shaped(String id) {
        return this.register(id, this.storage.shapedSchema);
    }

    public RecipeNamespace shapeless(String id) {
        return this.register(id, this.storage.shapelessSchema);
    }

    public RecipeNamespace special(String id) {
        return this.register(id, this.storage.specialSchema);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

