/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.mixin.PonderIndexAccessor;
import com.almostreliable.ponderjs.util.PonderErrorHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class PonderLang {
    public static final String PATH = "kubejs/assets/ponderjs_generated/lang/%lang%.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static boolean GENERATING_LANG = false;

    public static void initLanguage(boolean ignoreSharedText) {
        block5: {
            if (!PonderIndexAccessor.getPlugins().contains(PonderJS.PLUGIN)) {
                return;
            }
            GENERATING_LANG = true;
            try {
                if (!PonderLang.generate("en_us")) break block5;
                try {
                    Minecraft.getInstance().reloadResourcePacks();
                }
                catch (Exception e) {
                    throw new RuntimeException("Something went wrong while reloading resources after PonderJS init. You have to manually reload the resources for the changes to take effect.", e);
                }
            }
            catch (Exception e) {
                PonderErrorHelper.yeet(e);
            }
        }
        GENERATING_LANG = false;
    }

    public static boolean generate(String langName) {
        File file = new File(PATH.replace("%lang%", langName));
        JsonObject existingLang = PonderLang.read(file);
        JsonObject currentLang = PonderLang.createFromLocalization();
        if (currentLang.equals((Object)existingLang)) {
            return false;
        }
        PonderJS.LOGGER.info("PonderJS - New lang file differ from existing lang file, generating new lang file.\n Old Lang size: {} \n\n New lang size: {}", (Object)(existingLang == null ? 0 : existingLang.size()), (Object)currentLang.size());
        return PonderLang.write(file, currentLang);
    }

    private static boolean write(File file, JsonObject currentLang) {
        try {
            String output = GSON.toJson((JsonElement)currentLang);
            FileUtils.writeStringToFile((File)file, (String)output, (Charset)StandardCharsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            PonderJS.LOGGER.error((Object)e);
            return false;
        }
    }

    @Nullable
    protected static JsonObject read(File file) {
        if (file.exists()) {
            try {
                String s = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                return (JsonObject)GSON.fromJson(s, JsonObject.class);
            }
            catch (IOException e) {
                PonderJS.LOGGER.error((Object)e);
            }
        }
        return null;
    }

    public static JsonObject createFromLocalization() {
        JsonObject object = new JsonObject();
        for (String namespace : PonderJS.NAMESPACES) {
            PonderIndex.getLangAccess().provideLang(namespace, (arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        }
        return object;
    }
}

