/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class ManagedUUID
extends AbstractManagedData<UUID> {
    @Nullable
    private UUID value;
    protected Function<UUID, UUID> validator = null;

    public ManagedUUID(String name, @Nullable UUID defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedUUID(String name, DataFlags ... flags) {
        this(name, (UUID)null, flags);
    }

    public UUID set(@Nullable UUID value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            UUID prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public UUID get() {
        return this.value;
    }

    public ManagedUUID setValidator(Function<UUID, UUID> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeUUID(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readUUID() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        if (this.value != null) {
            compound.putUUID(this.name, this.value);
        }
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        this.value = compound.contains(this.name) ? compound.getUUID(this.name) : null;
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + String.valueOf(this.value) + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

