/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ManagedVector3i
extends AbstractManagedData<Vec3i> {
    private Vec3i value;
    private Vec3i defaultValue;
    protected Function<Vec3i, Vec3i> validator = null;

    public ManagedVector3i(String name, @Nullable Vec3i defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : new Vec3i(defaultValue.getX(), defaultValue.getY(), defaultValue.getZ());
    }

    public ManagedVector3i(String name, DataFlags ... flags) {
        this(name, new Vec3i(0, 0, 0), flags);
    }

    public Vec3i set(Vec3i value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            Vec3i prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public Vec3i get() {
        return this.value;
    }

    public ManagedVector3i setValidator(Function<Vec3i, Vec3i> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeVec3i(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readVec3i() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        if (this.value == null) {
            nbt.putBoolean("null", true);
        } else {
            nbt.putInt("x", this.value.getX());
            nbt.putInt("y", this.value.getY());
            nbt.putInt("z", this.value.getZ());
        }
        compound.put(this.name, (Tag)nbt);
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag nbt;
        this.value = !compound.contains(this.name, 10) ? (this.defaultValue == null ? null : new Vec3i(this.defaultValue.getX(), this.defaultValue.getY(), this.defaultValue.getZ())) : ((nbt = compound.getCompound(this.name)).contains("null") ? null : new Vec3i(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z")));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + String.valueOf(this.value) + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

