/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridClearHandler;
import net.blay09.mods.craftingtweaks.api.GridRefillHandler;
import net.blay09.mods.craftingtweaks.api.GridRotateHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.blay09.mods.craftingtweaks.api.InternalMethods;
import net.blay09.mods.craftingtweaks.api.RecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.api.impl.DefaultFourByFourGridRotateHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridClearHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridRefillHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridRotateHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridTransferHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultRectangleGridRotateHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;

public class InternalMethodsImpl
implements InternalMethods {
    private static final Map<Class<? extends Recipe<?>>, RecipeMatrixMapper<? extends Recipe<?>>> recipeMatrixMappers = new HashMap();

    @Override
    public void registerCraftingGridProvider(CraftingGridProvider provider) {
        CraftingTweaksProviderManager.registerProvider(provider);
    }

    @Override
    public void unregisterCraftingGridProvider(CraftingGridProvider provider) {
        CraftingTweaksProviderManager.unregisterProvider(provider);
    }

    @Override
    public GridTransferHandler<AbstractContainerMenu> defaultTransferHandler() {
        return new DefaultGridTransferHandler();
    }

    @Override
    public GridBalanceHandler<AbstractContainerMenu> defaultBalanceHandler() {
        return new DefaultGridBalanceHandler();
    }

    @Override
    public GridClearHandler<AbstractContainerMenu> defaultClearHandler() {
        return new DefaultGridClearHandler();
    }

    @Override
    public GridRotateHandler<AbstractContainerMenu> defaultRotateHandler() {
        return new DefaultGridRotateHandler();
    }

    @Override
    public GridRotateHandler<AbstractContainerMenu> defaultFourByFourRotateHandler() {
        return new DefaultFourByFourGridRotateHandler();
    }

    @Override
    public GridRotateHandler<AbstractContainerMenu> defaultRectangularRotateHandler() {
        return new DefaultRectangleGridRotateHandler();
    }

    @Override
    public GridRefillHandler<AbstractContainerMenu> defaultRefillHandler() {
        return new DefaultGridRefillHandler();
    }

    @Override
    public Optional<RecipeHolder<?>> getLastCraftedRecipe(Player player) {
        Level level = player.level();
        RecipeManager recipeManager = level.getRecipeManager();
        CompoundTag persistentData = Balm.getHooks().getPersistentData(player);
        ResourceLocation lastCraftedRecipeId = ResourceLocation.tryParse((String)persistentData.getString("LastCraftedRecipe"));
        if (lastCraftedRecipeId != null) {
            return recipeManager.byKey(lastCraftedRecipeId);
        }
        return Optional.empty();
    }

    @Override
    public <T extends Recipe<? extends RecipeInput>> void setLastCraftedRecipe(Player player, RecipeHolder<T> recipe) {
        CompoundTag persistentData = Balm.getHooks().getPersistentData(player);
        persistentData.putString("LastCraftedRecipe", recipe.id().toString());
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> void registerRecipeMatrixMapper(Class<T> recipeClass, RecipeMatrixMapper<T> recipeMatrixMapper) {
        recipeMatrixMappers.put(recipeClass, recipeMatrixMapper);
    }

    @Override
    public <T extends Recipe<? extends RecipeInput>> RecipeMatrixMapper<T> getRecipeMatrixMapper(Class<T> recipeClass) {
        for (Class<Recipe<T>> clazz : recipeMatrixMappers.keySet()) {
            if (!clazz.isAssignableFrom(recipeClass)) continue;
            return recipeMatrixMappers.get(clazz);
        }
        return recipeMatrixMappers.get(recipeClass);
    }
}

