/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.items;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.init.ItemData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyLinkModuleItem
extends ModuleItem<EnergyLinkData> {
    public EnergyLinkModuleItem(Item.Properties properties, Supplier<Module<?>> moduleSupplier) {
        super(properties, moduleSupplier);
    }

    public EnergyLinkModuleItem(Supplier<Module<?>> moduleSupplier) {
        super(new Item.Properties().stacksTo(1), moduleSupplier);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (TimeKeeper.getServerTick() % 20 == 0) break block3;
            }
            return;
        }
        EnergyLinkModuleItem.checkResetLink(stack, serverLevel);
    }

    public static void checkResetLink(ItemStack stack, ServerLevel level) {
        boolean reset;
        GlobalPos pos = (GlobalPos)stack.get(ItemData.LINK_MODULE_LINK_POS);
        UUID uuid = (UUID)stack.get(ItemData.LINK_MODULE_LINK_ID);
        if (pos == null || uuid == null) {
            return;
        }
        ServerLevel coreLevel = level.getServer().getLevel(pos.dimension());
        boolean bl = reset = coreLevel == null;
        if (!reset) {
            BlockEntity blockEntity = coreLevel.getBlockEntity(pos.pos());
            if (blockEntity instanceof TileEnergyCore) {
                TileEnergyCore core = (TileEnergyCore)blockEntity;
                if (!uuid.equals(core.linkUUID.get())) {
                    reset = true;
                }
            } else {
                reset = true;
            }
        }
        if (reset) {
            stack.remove(ItemData.LINK_MODULE_LINK_POS);
            stack.remove(ItemData.LINK_MODULE_LINK_ID);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level.isClientSide || player == null || !player.isShiftKeyDown()) {
            return InteractionResult.SUCCESS;
        }
        Object blockEntity = level.getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock structureBlock = (TileStructureBlock)((Object)blockEntity);
            blockEntity = (BlockEntity)structureBlock.getController();
        }
        if (blockEntity instanceof TileEnergyPylon) {
            TileEnergyPylon pylon = (TileEnergyPylon)blockEntity;
            blockEntity = pylon.getCore();
        }
        if (blockEntity instanceof TileEnergyCoreStabilizer) {
            TileEnergyCoreStabilizer stabilizer = (TileEnergyCoreStabilizer)blockEntity;
            blockEntity = stabilizer.getCore();
        }
        if (!(blockEntity instanceof TileEnergyCore)) {
            return InteractionResult.PASS;
        }
        TileEnergyCore core = (TileEnergyCore)blockEntity;
        UUID linkId = core.linkUUID.get();
        if (!core.active.get() || linkId == null) {
            player.sendSystemMessage((Component)Component.translatable((String)"module.draconicevolution.energy_link.core_not_active"));
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = core.getBlockPos();
        stack.set(ItemData.LINK_MODULE_LINK_POS, (Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos));
        stack.set(ItemData.LINK_MODULE_LINK_ID, (Object)linkId);
        return InteractionResult.CONSUME;
    }
}

