/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FusionCraftingCore
extends EntityBlockBCore {
    private static final VoxelShape SHAPE = Shapes.box((double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375);

    public FusionCraftingCore(BlockBehaviour.Properties properties) {
        super(properties);
        this.setBlockEntity(() -> DEContent.TILE_CRAFTING_CORE.get(), true);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile;
        if (!world.isClientSide() && FusionCraftingCore.isBlockPowered((LevelReader)world, (BlockPos)pos) && (tile = world.getBlockEntity(pos)) instanceof TileFusionCraftingCore) {
            ((TileFusionCraftingCore)tile).startCraft();
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tile = worldIn.getBlockEntity(pos);
        if (tile instanceof TileFusionCraftingCore) {
            return ((TileFusionCraftingCore)tile).getComparatorOutput();
        }
        return super.getAnalogOutputSignal(blockState, worldIn, pos);
    }
}

