/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class StabilizedSpawner
extends EntityBlockBCore {
    public StabilizedSpawner(BlockBehaviour.Properties properties) {
        super(properties);
        this.setMobResistant();
        this.setExplosionResistant();
        this.setBlockEntity(() -> DEContent.TILE_STABILIZED_SPAWNER.get(), true);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        ItemStack soul;
        byte index;
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (!stack.has(BlockBCore.BC_TILE_DATA_TAG) || context.level() == null) {
            return;
        }
        CompoundTag tag = ((CustomData)stack.get(BlockBCore.BC_TILE_DATA_TAG)).copyTag();
        CompoundTag data = tag.getCompound("bc_managed_data");
        CompoundTag tier = data.getCompound("spawner_tier");
        if (tier.contains("value") && (index = tier.getByte("value")) >= 0 && index < TileStabilizedSpawner.SpawnerTier.values().length) {
            TechLevel techLevel = TileStabilizedSpawner.SpawnerTier.values()[index].getTechLevel();
            tooltip.add((Component)techLevel.getDisplayName().copy().withStyle(techLevel.getTextColour()));
        }
        if (data.contains("mob_soul") && !(soul = ItemStack.parseOptional((HolderLookup.Provider)context.level().registryAccess(), (CompoundTag)data.getCompound("mob_soul"))).isEmpty()) {
            tooltip.add((Component)soul.getDisplayName().copy().withStyle(ChatFormatting.YELLOW));
        }
    }
}

