/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.util.RotationUtils;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReactorComponent
extends EntityBlockBCore {
    private static final VoxelShape SHAPE_INJ_DOWN = Shapes.box((double)0.0, (double)0.885f, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_UP = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_INJ_NORTH = Shapes.box((double)0.0, (double)0.0, (double)0.885f, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_SOUTH = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125);
    private static final VoxelShape SHAPE_INJ_WEST = Shapes.box((double)0.885f, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_EAST = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0);
    private final boolean injector;

    public ReactorComponent(BlockBehaviour.Properties properties, boolean injector) {
        super(properties);
        this.injector = injector;
        this.setBlockEntity(() -> injector ? (BlockEntityType)DEContent.TILE_REACTOR_INJECTOR.get() : (BlockEntityType)DEContent.TILE_REACTOR_STABILIZER.get(), true);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileReactorInjector) {
            switch ((Direction)((TileReactorInjector)tile).facing.get()) {
                case DOWN: {
                    return SHAPE_INJ_DOWN;
                }
                case UP: {
                    return SHAPE_INJ_UP;
                }
                case NORTH: {
                    return SHAPE_INJ_NORTH;
                }
                case SOUTH: {
                    return SHAPE_INJ_SOUTH;
                }
                case WEST: {
                    return SHAPE_INJ_WEST;
                }
                case EAST: {
                    return SHAPE_INJ_EAST;
                }
            }
        }
        return super.getShape(state, world, pos, context);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        BlockEntity te = world.getBlockEntity(pos);
        Direction facing = RotationUtils.getPlacedRotation((BlockPos)pos, (LivingEntity)placer).getOpposite();
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).facing.set((Enum)facing);
            ((TileReactorComponent)te).onPlaced();
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onActivated(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onBroken();
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof TileReactorComponent) {
            return ((TileReactorComponent)tileEntity).rsPower.get();
        }
        return 0;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        level.levelEvent(player, 2001, pos, ReactorComponent.getId((BlockState)state));
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }
}

