/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.init.EquipCfg;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class DETier
implements Tier {
    private TechLevel techLevel;

    public DETier(TechLevel techLevel) {
        this.techLevel = techLevel;
    }

    public int getUses() {
        return 0;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return switch (this.techLevel) {
            case TechLevel.WYVERN -> DETags.Blocks.INCORRECT_FOR_WYVERN_TOOL;
            case TechLevel.DRACONIC -> DETags.Blocks.INCORRECT_FOR_AWAKENED_TOOL;
            case TechLevel.CHAOTIC -> DETags.Blocks.INCORRECT_FOR_CHAOTIC_TOOL;
            default -> BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        };
    }

    public int getEnchantmentValue() {
        return DETier.getEnchantability(this.techLevel);
    }

    public static int getEnchantability(TechLevel techLevel) {
        return switch (techLevel) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> EquipCfg.draconiumEnchantability;
            case TechLevel.WYVERN -> EquipCfg.wyvernEnchantability;
            case TechLevel.DRACONIC -> EquipCfg.draconicEnchantability;
            case TechLevel.CHAOTIC -> EquipCfg.chaoticEnchantability;
        };
    }

    public float getSpeed() {
        return switch (this.techLevel) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> (float)EquipCfg.draconiumHarvestSpeed;
            case TechLevel.WYVERN -> (float)EquipCfg.wyvernHarvestSpeed;
            case TechLevel.DRACONIC -> (float)EquipCfg.draconicHarvestSpeed;
            case TechLevel.CHAOTIC -> (float)EquipCfg.chaoticHarvestSpeed;
        };
    }

    public float getAttackDamageBonus() {
        return switch (this.techLevel) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> (float)EquipCfg.draconiumDamage;
            case TechLevel.WYVERN -> (float)EquipCfg.wyvernDamage;
            case TechLevel.DRACONIC -> (float)EquipCfg.draconicDamage;
            case TechLevel.CHAOTIC -> (float)EquipCfg.chaoticDamage;
        };
    }

    public float getAttackSpeed() {
        return switch (this.techLevel) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> (float)EquipCfg.draconiumSwingSpeed;
            case TechLevel.WYVERN -> (float)EquipCfg.wyvernSwingSpeed;
            case TechLevel.DRACONIC -> (float)EquipCfg.draconicSwingSpeed;
            case TechLevel.CHAOTIC -> (float)EquipCfg.chaoticSwingSpeed;
        };
    }

    public Ingredient getRepairIngredient() {
        return Ingredient.EMPTY;
    }
}

