/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.ServerPayloadContext;

public record RequestBlockPacket(BlockAccessorImpl.SyncData data, List<@Nullable IServerDataProvider<BlockAccessor>> dataProviders) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestBlockPacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_REQUEST_BLOCK);
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestBlockPacket> CODEC = StreamCodec.composite(BlockAccessorImpl.SyncData.STREAM_CODEC, RequestBlockPacket::data, (StreamCodec)ByteBufCodecs.list().apply(ByteBufCodecs.idMapper($ -> (IServerDataProvider)Objects.requireNonNull(WailaCommonRegistration.instance().blockDataProviders.idMapper()).byId($), $ -> Objects.requireNonNull(WailaCommonRegistration.instance().blockDataProviders.idMapper()).getIdOrThrow($))), RequestBlockPacket::dataProviders, RequestBlockPacket::new);

    public static void handle(RequestBlockPacket message, ServerPayloadContext context) {
        BlockAccessorImpl.handleRequest(message, context, tag -> ReceiveDataPacket.send(tag, context));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

