/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;

public class BotanyPotFileGenerator {
    private final File outDir;
    private final String ownerId;
    private static final String BASIC_POT_MODEL_TEMPLATE = "{\n    \"parent\": \"botanypots:block/template/pot\",\n    \"render_type\": \"minecraft:cutout\",\n    \"textures\": {\n        \"material\": \"minecraft:block/$texture\",\n        \"material_top\": \"botanypots:block/$texture_pot_top\"\n    }\n}\n";
    private static final String HOPPER_POT_MODEL_TEMPLATE = "{\n    \"parent\": \"botanypots:block/template/hopper_pot\",\n    \"render_type\": \"minecraft:cutout\",\n    \"textures\": {\n        \"material\": \"minecraft:block/$texture\",\n        \"material_top\": \"botanypots:block/$texture_pot_top\"\n    }\n}\n";
    private static final String BLOCK_ITEM_MODEL_TEMPLATE = "{\n    \"parent\": \"$owner:block/$block_name\"\n}\n";
    private static final String BLOCK_STATE_TEMPLATE = "{\n  \"variants\": {\n    \"\": {\n      \"model\": \"$owner:block/$model_name\"\n    }\n  }\n}\n";
    private static final String BASIC_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypots:config\",\n            \"property\": \"can_craft_basic_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"category\": \"misc\",\n    \"group\": \"botanypots:basic_pot\",\n    \"pattern\": [\"M M\", \"MPM\", \" M \"],\n    \"key\": {\n        \"M\": {\n            \"item\": \"$material_id\"\n        },\n        \"P\": {\n            \"item\": \"minecraft:flower_pot\"\n        }\n    },\n    \"result\": {\n        \"id\": \"$owner:$material_name_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String HOPPER_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypots:config\",\n            \"property\": \"can_craft_hopper_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"category\": \"misc\",\n    \"group\": \"botanypots:hopper_pot\",\n    \"ingredients\": [\n        {\n            \"item\": \"minecraft:hopper\"\n        },\n        {\n            \"item\": \"$owner:$material_name_botany_pot\"\n        }\n    ],\n    \"result\": {\n        \"id\": \"$owner:$material_name_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String QUICK_HOPPER_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypots:config\",\n            \"property\": \"can_craft_hopper_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"category\": \"misc\",\n    \"group\": \"botanypots:quick_hopper_pot\",\n    \"pattern\": [\"MHM\", \"MPM\", \" M \"],\n    \"key\": {\n        \"M\": {\n            \"item\": \"$material_id\"\n        },\n        \"P\": {\n            \"item\": \"minecraft:flower_pot\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"id\": \"$owner:$material_name_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String WAX_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypots:config\",\n            \"property\": \"can_wax_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"category\": \"misc\",\n    \"group\": \"botanypots:waxed_pot\",\n    \"ingredients\": [\n        {\n            \"item\": \"minecraft:honeycomb\"\n        },\n        {\n            \"item\": \"$owner:$material_name_botany_pot\"\n        }\n    ],\n    \"result\": {\n        \"id\": \"$owner:$material_name_waxed_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String DROP_SELF_TABLE = "{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"$block_id\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ],\n  \"random_sequence\": \"$block_id\"\n}\n";

    public BotanyPotFileGenerator(File outDir, String ownerId) {
        this.outDir = outDir;
        this.ownerId = ownerId;
    }

    public void potRecipes(ResourceLocation material) {
        File craftingDir = BotanyPotFileGenerator.setup(new File(this.outDir, "data/" + this.ownerId + "/recipe/" + this.ownerId + "/crafting"));
        this.basicPotRecipe(craftingDir, material);
        this.hopperPotRecipe(craftingDir, material);
        this.quickHopperPotRecipe(craftingDir, material);
        this.waxedPotRecipe(craftingDir, material);
    }

    public void lootTables(ResourceLocation material) {
        File lootDir = BotanyPotFileGenerator.setup(new File(this.outDir, "loot_table/blocks"));
        this.lootTable(lootDir, ResourceLocation.fromNamespaceAndPath((String)this.ownerId, (String)(material.getPath() + "_botany_pot")));
        this.lootTable(lootDir, ResourceLocation.fromNamespaceAndPath((String)this.ownerId, (String)(material.getPath() + "_hopper_botany_pot")));
        this.lootTable(lootDir, ResourceLocation.fromNamespaceAndPath((String)this.ownerId, (String)(material.getPath() + "_waxed_botany_pot")));
    }

    public void models(ResourceLocation material) {
        File modelDir = BotanyPotFileGenerator.setup(new File(this.outDir, "assets/" + this.ownerId + "/models"));
        File blockDir = BotanyPotFileGenerator.setup(new File(modelDir, "block"));
        File itemDir = BotanyPotFileGenerator.setup(new File(modelDir, "item"));
        File stateDir = BotanyPotFileGenerator.setup(new File(this.outDir, "assets/" + this.ownerId + "/blockstates"));
        BotanyPotFileGenerator.write(new File(blockDir, material.getPath() + "_botany_pot.json"), BASIC_POT_MODEL_TEMPLATE.replace("$texture", material.getPath()));
        BotanyPotFileGenerator.write(new File(itemDir, material.getPath() + "_botany_pot.json"), BLOCK_ITEM_MODEL_TEMPLATE.replace("$owner", this.ownerId).replace("$block_name", material.getPath() + "_botany_pot"));
        BotanyPotFileGenerator.write(new File(stateDir, material.getPath() + "_botany_pot.json"), BLOCK_STATE_TEMPLATE.replace("$owner", this.ownerId).replace("$model_name", material.getPath() + "_botany_pot"));
        BotanyPotFileGenerator.write(new File(blockDir, material.getPath() + "_hopper_botany_pot.json"), HOPPER_POT_MODEL_TEMPLATE.replace("$texture", material.getPath()));
        BotanyPotFileGenerator.write(new File(itemDir, material.getPath() + "_hopper_botany_pot.json"), BLOCK_ITEM_MODEL_TEMPLATE.replace("$owner", this.ownerId).replace("$block_name", material.getPath() + "_hopper_botany_pot"));
        BotanyPotFileGenerator.write(new File(stateDir, material.getPath() + "_hopper_botany_pot.json"), BLOCK_STATE_TEMPLATE.replace("$owner", this.ownerId).replace("$model_name", material.getPath() + "_hopper_botany_pot"));
        BotanyPotFileGenerator.write(new File(blockDir, material.getPath() + "_waxed_botany_pot.json"), BASIC_POT_MODEL_TEMPLATE.replace("$texture", material.getPath()));
        BotanyPotFileGenerator.write(new File(itemDir, material.getPath() + "_waxed_botany_pot.json"), BLOCK_ITEM_MODEL_TEMPLATE.replace("$owner", this.ownerId).replace("$block_name", material.getPath() + "_botany_pot"));
        BotanyPotFileGenerator.write(new File(stateDir, material.getPath() + "_waxed_botany_pot.json"), BLOCK_STATE_TEMPLATE.replace("$owner", this.ownerId).replace("$model_name", material.getPath() + "_botany_pot"));
    }

    public void basicPotRecipe(File recipeDir, ResourceLocation material) {
        BotanyPotFileGenerator.write(new File(recipeDir, material.getPath() + "_botany_pot.json"), this.format(BASIC_POT_RECIPE_TEMPLATE, material));
    }

    public void hopperPotRecipe(File recipeDir, ResourceLocation material) {
        BotanyPotFileGenerator.write(new File(recipeDir, material.getPath() + "_hopper_botany_pot.json"), this.format(HOPPER_POT_RECIPE_TEMPLATE, material));
    }

    public void quickHopperPotRecipe(File recipeDir, ResourceLocation material) {
        BotanyPotFileGenerator.write(new File(recipeDir, material.getPath() + "_hopper_botany_pot_quick.json"), this.format(QUICK_HOPPER_POT_RECIPE_TEMPLATE, material));
    }

    public void waxedPotRecipe(File recipeDir, ResourceLocation material) {
        BotanyPotFileGenerator.write(new File(recipeDir, material.getPath() + "_waxed_botany_pot.json"), this.format(WAX_POT_RECIPE_TEMPLATE, material));
    }

    public void lootTable(File lootDir, ResourceLocation blockId) {
        BotanyPotFileGenerator.write(new File(lootDir, blockId.getPath() + ".json"), DROP_SELF_TABLE.replace("$block_id", blockId.toString()));
    }

    private String format(String template, ResourceLocation material) {
        return template.replace("$owner", this.ownerId).replace("$material_id", material.toString()).replace("$material_name", material.getPath());
    }

    private static void write(File file, String text) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String ... args) {
        File blockTextures = new File("F:\\Minecraft\\game_data\\1.21\\assets\\minecraft\\textures\\block");
        File outDir = new File("botanypots/images");
        outDir.mkdirs();
        for (File file : blockTextures.listFiles()) {
            if (!file.getName().endsWith(".png")) continue;
            File outputImg = new File(outDir, file.getName().substring(0, file.getName().length() - 4) + "_pot_top.png");
            try {
                outputImg.createNewFile();
                BotanyPotFileGenerator.makeTopTexture(file, outputImg);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static File setup(File dir) {
        dir.mkdirs();
        return dir;
    }

    public static void makeTopTexture(File inputFile, File outputFile) {
        try {
            BufferedImage image = ImageIO.read(inputFile);
            BufferedImage output = new BufferedImage(16, 16, 2);
            if (image.getWidth() != 16 || image.getHeight() != 16) {
                return;
            }
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    if (y == 0 && x <= 11) {
                        output.setRGB(x, y, image.getRGB(x, 0));
                        continue;
                    }
                    if (x == 0 && y <= 11) {
                        output.setRGB(x, y, image.getRGB(y, 0));
                        continue;
                    }
                    if (x == 11 && y <= 11) {
                        output.setRGB(x, y, image.getRGB(11 - y, 0));
                        continue;
                    }
                    if (y == 11 && x <= 11) {
                        output.setRGB(x, y, image.getRGB(11 - x, 0));
                        continue;
                    }
                    output.setRGB(x, y, 0xFFFFFF);
                }
            }
            ImageIO.write((RenderedImage)output, "PNG", outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

