/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;

public class EntityDisplayState
implements Display {
    public static final ResourceLocation TYPE_ID = BotanyPotsMod.id("entity");
    public static final CachedSupplier<DisplayType<EntityDisplayState>> TYPE = CachedSupplier.cache(() -> DisplayType.get(TYPE_ID));
    public static final MapCodec<EntityDisplayState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CompoundTag.CODEC.fieldOf("entity").forGetter(EntityDisplayState::getEntityData), (App)Codec.BOOL.optionalFieldOf("should_tick", (Object)true).forGetter(EntityDisplayState::shouldTickEntity), (App)Codec.INT.optionalFieldOf("spin_speed", (Object)0).forGetter(EntityDisplayState::getSpinSpeed), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("scale", (Object)new Vector3f(0.5f, 0.5f, 0.5f)).forGetter(EntityDisplayState::getScale), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("offset").forGetter(EntityDisplayState::getOffset)).apply((Applicative)instance, EntityDisplayState::new));
    public static final StreamCodec<FriendlyByteBuf, EntityDisplayState> STREAM = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, EntityDisplayState::getEntityData, (StreamCodec)ByteBufCodecs.BOOL, EntityDisplayState::shouldTickEntity, (StreamCodec)ByteBufCodecs.INT, EntityDisplayState::getSpinSpeed, (StreamCodec)ByteBufCodecs.VECTOR3F, EntityDisplayState::getScale, (StreamCodec)DataHelper.optionalStream((StreamCodec)ByteBufCodecs.VECTOR3F), EntityDisplayState::getOffset, EntityDisplayState::new);
    private final CompoundTag entityData;
    private final boolean tickEntity;
    private final int spinSpeed;
    private final Vector3f scale;
    private final Optional<Vector3f> offset;
    private final ReloadableCache<Entity> displayEntity;

    public EntityDisplayState(CompoundTag displayEntity, boolean shouldTick, int spinSpeed, Vector3f scale, Optional<Vector3f> offset) {
        this.entityData = displayEntity;
        this.tickEntity = shouldTick;
        this.spinSpeed = spinSpeed;
        this.scale = scale;
        this.offset = offset;
        this.displayEntity = ReloadableCache.entity((CompoundTag)displayEntity);
    }

    public CompoundTag getEntityData() {
        return this.entityData;
    }

    public boolean shouldTickEntity() {
        return this.tickEntity;
    }

    public int getSpinSpeed() {
        return this.spinSpeed;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public Optional<Vector3f> getOffset() {
        return this.offset;
    }

    public ReloadableCache<Entity> getDisplayEntity() {
        return this.displayEntity;
    }

    @Override
    public DisplayType<?> getType() {
        return (DisplayType)TYPE.get();
    }
}

