/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.networking;

import com.google.common.collect.Maps;
import de.mari_023.ae2wtlib.api.AE2wtlibAPI;
import de.mari_023.ae2wtlib.networking.AE2wtlibPacket;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public record RestockAmountPacket(HashMap<Holder<Item>, Long> items) implements AE2wtlibPacket
{
    public static final CustomPacketPayload.Type<RestockAmountPacket> ID = new CustomPacketPayload.Type(AE2wtlibAPI.id((String)"restock_amounts"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RestockAmountPacket> STREAM_CODEC = ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), (StreamCodec)ByteBufCodecs.VAR_LONG).map(RestockAmountPacket::new, RestockAmountPacket::items);

    @Override
    public void processPacketData(Player player) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.items().size());
        this.items().forEach((item, count) -> map.put((Item)item.value(), count));
        CraftingTerminalHandler.getCraftingTerminalHandler(player).setRestockAbleItems(map);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

