/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.common.containers.FilterContainer;
import com.direwolf20.mininggadgets.common.containers.GhostSlot;
import com.direwolf20.mininggadgets.common.network.data.GhostSlotPayload;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterScreen
extends AbstractContainerScreen<FilterContainer> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/gui/container/generic_54.png");

    public FilterScreen(FilterContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, Component.translatable((String)"mininggadgets.tooltip.single.filters").getString(), 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, ((FilterContainer)this.menu).getCarried().getDisplayName().getString(), 8, this.imageHeight - 96 + 3, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, 71);
        guiGraphics.blit(TEXTURE, x, y + 71, 0, 126, this.imageWidth, 96);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (this.hoveredSlot == null || !(this.hoveredSlot instanceof GhostSlot)) {
            return super.mouseClicked(x, y, btn);
        }
        ItemStack stack = ((FilterContainer)this.menu).getCarried();
        stack = stack.copy().split(this.hoveredSlot.getMaxStackSize());
        this.hoveredSlot.set(stack);
        PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public boolean mouseReleased(double x, double y, int btn) {
        if (this.hoveredSlot == null || !(this.hoveredSlot instanceof GhostSlot)) {
            return super.mouseReleased(x, y, btn);
        }
        return true;
    }

    public boolean mouseScrolled(double x, double y, double amt, double amtY) {
        if (this.hoveredSlot == null || !(this.hoveredSlot instanceof GhostSlot)) {
            return super.mouseScrolled(x, y, amt, amtY);
        }
        return true;
    }
}

