/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.util;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.mixin.AbuseReportContextAccessor;
import com.mrbysco.neoauth.mixin.MinecraftClientAccessor;
import com.mrbysco.neoauth.mixin.RealmsAvailabilityAccessor;
import com.mrbysco.neoauth.mixin.SplashTextResourceSupplierAccessor;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;

public final class SessionUtils {
    public static final String OFFLINE_TOKEN = "invalidtoken";
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static User getSession() {
        return Minecraft.getInstance().getUser();
    }

    public static void setSession(User session) {
        Minecraft client = Minecraft.getInstance();
        ((MinecraftClientAccessor)client).setUser(session);
        ((SplashTextResourceSupplierAccessor)client.getSplashManager()).setUser(session);
        ((MinecraftClientAccessor)client).setProfileFuture(CompletableFuture.supplyAsync(() -> client.getMinecraftSessionService().fetchProfile(session.getProfileId(), true), Util.nonCriticalIoPool()));
        UserApiService userApiService = UserApiService.OFFLINE;
        if (!OFFLINE_TOKEN.equals(session.getAccessToken())) {
            userApiService = SessionUtils.getAuthService().createUserApiService(session.getAccessToken());
        }
        ((MinecraftClientAccessor)client).setUserApiService(userApiService);
        ((MinecraftClientAccessor)client).setPlayerSocialManager(new PlayerSocialManager(client, userApiService));
        ((MinecraftClientAccessor)client).setProfileKeyPairManager(ProfileKeyPairManager.create((UserApiService)userApiService, (User)session, (Path)client.gameDirectory.toPath()));
        ((MinecraftClientAccessor)client).setReportingContext(ReportingContext.create((ReportEnvironment)((AbuseReportContextAccessor)client.getReportingContext()).getEnvironment(), (UserApiService)userApiService));
        RealmsClient realmsClient = RealmsClient.create((Minecraft)client);
        ((MinecraftClientAccessor)client).setRealmsDataFetcher(new RealmsDataFetcher(realmsClient));
        RealmsAvailabilityAccessor.setFuture(null);
        lastStatus = SessionStatus.UNKNOWN;
        lastStatusCheck = 0L;
        NeoAuth.LOGGER.info("Minecraft session for {} (uuid={}) has been applied", (Object)session.getName(), (Object)session.getProfileId());
    }

    public static User offline(String username) {
        return new User(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()), OFFLINE_TOKEN, Optional.empty(), Optional.empty(), User.Type.LEGACY);
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            User session = SessionUtils.getSession();
            String serverId = UUID.randomUUID().toString();
            YggdrasilMinecraftSessionService sessionService = SessionUtils.getSessionService();
            try {
                NeoAuth.LOGGER.info("Verifying Minecraft session...");
                sessionService.joinServer(session.getProfileId(), session.getAccessToken(), serverId);
                if (sessionService.hasJoinedServer(session.getName(), serverId, null) != null) {
                    NeoAuth.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    NeoAuth.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                NeoAuth.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static YggdrasilMinecraftSessionService getSessionService() {
        return (YggdrasilMinecraftSessionService)Minecraft.getInstance().getMinecraftSessionService();
    }

    public static YggdrasilAuthenticationService getAuthService() {
        return ((MinecraftClientAccessor)Minecraft.getInstance()).getAuthenticationService();
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

