/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ClientNetworkHelper;
import com.iafenvoy.jupiter.network.payload.ConfigErrorPayload;
import com.iafenvoy.jupiter.network.payload.ConfigRequestPayload;
import com.iafenvoy.jupiter.network.payload.ConfigSyncPayload;
import com.iafenvoy.jupiter.util.Comment;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientConfigNetwork {
    private static final Map<ResourceLocation, Consumer<CompoundTag>> CALLBACKS = new HashMap<ResourceLocation, Consumer<CompoundTag>>();

    public static void syncConfig(AbstractConfigContainer container) {
        ClientConfigNetwork.syncConfig(container.getConfigId(), container::deserializeNbt);
    }

    @Comment(value="will pass null to nbt if not allowed")
    public static void syncConfig(ResourceLocation id, Consumer<CompoundTag> callback) {
        CALLBACKS.put(id, callback);
        ClientNetworkHelper.sendToServer(new ConfigRequestPayload(id));
    }

    public static void init() {
        ClientNetworkHelper.registerReceiver(ConfigSyncPayload.ID, (client, payload) -> {
            Consumer<CompoundTag> callback = CALLBACKS.get(payload.id());
            if (callback == null) {
                return null;
            }
            if (payload.allow()) {
                CompoundTag data = payload.compound();
                return () -> callback.accept(data);
            }
            return () -> callback.accept(null);
        });
        ClientNetworkHelper.registerReceiver(ConfigErrorPayload.ID, (client, buf) -> () -> client.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.WORLD_ACCESS_FAILURE, (Component)Component.translatable((String)"jupiter.toast.upload_config_error_title"), (Component)Component.translatable((String)"jupiter.toast.upload_config_error_content"))));
    }
}

