/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.config.container.FileConfigContainer;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.render.screen.ClientConfigScreen;
import com.iafenvoy.jupiter.render.screen.ServerConfigScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ConfigSelectScreen<S extends FileConfigContainer, C extends FileConfigContainer>
extends Screen {
    private final Screen parent;
    private final S serverConfig;
    @Nullable
    private final C clientConfig;
    @Nullable
    private FakeConfigContainer fakeServerConfig;

    public ConfigSelectScreen(Component title, Screen parent, S serverConfig, @Nullable C clientConfig) {
        super(title);
        this.parent = parent;
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
    }

    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height / 2;
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"jupiter.screen.back"), button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }).bounds(x - 100, y - 25 - 10, 200, 20).build());
        Button serverButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"jupiter.screen.server_config"), button -> {
            assert (this.minecraft != null);
            assert (this.serverConfig != null);
            this.minecraft.setScreen((Screen)new ServerConfigScreen(this, this.getServerConfig()));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"jupiter.screen.check_server"))).bounds(x - 100, y - 10, 200, 20).build());
        serverButton.active = true;
        Button clientButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"jupiter.screen.client_config"), button -> {
            assert (this.minecraft != null);
            assert (this.clientConfig != null);
            this.minecraft.setScreen((Screen)new ClientConfigScreen(this, (AbstractConfigContainer)this.clientConfig));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)(this.clientConfig != null ? "jupiter.screen.open_client" : "jupiter.screen.disable_client")))).bounds(x - 100, y + 25 - 10, 200, 20).build());
        boolean bl = clientButton.active = this.clientConfig != null;
        if (this.connectedToDedicatedServer()) {
            this.fakeServerConfig = new FakeConfigContainer((AbstractConfigContainer)this.serverConfig);
            serverButton.active = false;
            ClientConfigNetwork.syncConfig(((AbstractConfigContainer)this.serverConfig).getConfigId(), nbt -> {
                if (nbt == null) {
                    serverButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jupiter.screen.disable_server")));
                } else {
                    try {
                        assert (this.fakeServerConfig != null);
                        this.fakeServerConfig.deserializeNbt((Tag)nbt);
                        serverButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jupiter.screen.open_server")));
                        serverButton.active = true;
                    }
                    catch (Exception e) {
                        Jupiter.LOGGER.error("Failed to parse server config data from server: {}", (Object)((AbstractConfigContainer)this.serverConfig).getConfigId(), (Object)e);
                        serverButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jupiter.screen.error_server")));
                    }
                }
            });
        } else {
            serverButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jupiter.screen.open_server")));
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        assert (this.minecraft != null);
        context.drawCenteredString(this.minecraft.font, this.title, this.width / 2, this.height / 2 - 50, -1);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private AbstractConfigContainer getServerConfig() {
        if (!this.connectedToDedicatedServer()) {
            return this.serverConfig;
        }
        assert (this.fakeServerConfig != null);
        return this.fakeServerConfig;
    }

    public boolean connectedToDedicatedServer() {
        assert (this.minecraft != null);
        ClientPacketListener handler = this.minecraft.getConnection();
        IntegratedServer server = this.minecraft.getSingleplayerServer();
        return handler != null && handler.getConnection().isConnected() && (server == null || server.isPublished());
    }
}

