/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ButtonWidgetBuilder<T>
extends WidgetBuilder<T> {
    private final Button.OnPress action = button -> {
        action.onPress(button);
        this.refresh();
    };
    private final Supplier<Component> nameSupplier;
    @Nullable
    private Button button;

    public ButtonWidgetBuilder(IConfigEntry<T> config, Button.OnPress action, Supplier<Component> nameSupplier) {
        super(config);
        this.nameSupplier = nameSupplier;
    }

    @Override
    public void addCustomElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        this.button = Button.builder((Component)this.nameSupplier.get(), (Button.OnPress)this.action).bounds(x, y, width, height).build();
        appender.accept((AbstractWidget)this.button);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.button == null) {
            return;
        }
        this.button.visible = visible;
        this.button.setY(y);
    }

    @Override
    public void refresh() {
        if (this.button == null) {
            return;
        }
        this.button.setMessage(this.nameSupplier.get());
    }
}

