/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2trees.worldgen.placers;

import com.mojang.serialization.MapCodec;
import com.pam.pamhc2trees.init.BlockRegistration;
import com.pam.pamhc2trees.worldgen.ConfiguredFeatures;
import com.pam.pamhc2trees.worldgen.placers.TrunkFruitTreeFoliagePlacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PaperbarkFruitTrunkPlacer
extends TrunkFruitTreeFoliagePlacer {
    private static BlockState fruit;
    public static final MapCodec<TrunkFruitTreeFoliagePlacer> CODEC;

    public PaperbarkFruitTrunkPlacer(BlockState fruit) {
        super(fruit);
    }

    public static BlockState getFruit() {
        return fruit;
    }

    public static void setFruit(BlockState fruit) {
        PaperbarkFruitTrunkPlacer.fruit = fruit;
    }

    protected FoliagePlacerType<?> type() {
        return ConfiguredFeatures.PAPERBARK_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource pRandom, TreeConfiguration pConfig, int p_273067_, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        for (int i = pOffset; i >= pOffset - pFoliageHeight; --i) {
            int j = Math.max(pFoliageRadius + pAttachment.radiusOffset() - 1 - i / 2, 0);
            this.placeLeavesRow(pLevel, foliageSetter, pRandom, pConfig, pAttachment.pos(), j - 1, i + 1, pAttachment.doubleTrunk());
        }
        this.placeFruitRow(pLevel, foliageSetter, pRandom, pConfig, pAttachment.pos(), 0, pOffset - 4, pAttachment.doubleTrunk());
        this.placeFruitRow(pLevel, foliageSetter, pRandom, pConfig, pAttachment.pos(), 0, pOffset - 5, pAttachment.doubleTrunk());
        this.placeFruitRow(pLevel, foliageSetter, pRandom, pConfig, pAttachment.pos(), 0, pOffset - 6, pAttachment.doubleTrunk());
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 4;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }

    protected void placeLeavesRow(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos, int p_161443_, int p_161444_, boolean p_161445_) {
        int i = p_161445_ ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = -p_161443_; j <= p_161443_ + i; ++j) {
            for (int k = -p_161443_; k <= p_161443_ + i; ++k) {
                if (this.shouldSkipLocationSigned(randomsource, j, p_161444_, k, p_161443_, p_161445_)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, j, p_161444_, k);
                PaperbarkFruitTrunkPlacer.tryPlaceLeaf(pLevel, foliageSetter, randomsource, treeconfig, (BlockPos)blockpos$mutableblockpos);
            }
        }
    }

    protected void placeFruitRow(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos, int p_161443_, int p_161444_, boolean p_161445_) {
        int i = p_161445_ ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = -p_161443_; j <= p_161443_ + i; ++j) {
            for (int k = -p_161443_; k <= p_161443_ + i; ++k) {
                if (this.shouldSkipLocationSigned(randomsource, j, p_161444_, k, p_161443_, p_161445_)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, j, p_161444_, k);
                this.tryPlaceFruit(pLevel, foliageSetter, randomsource, treeconfig, (BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)pos, j, p_161444_, k));
            }
        }
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos) {
        if (PaperbarkFruitTrunkPlacer.validTreePos(pLevel, pos)) {
            foliageSetter.set(pos, treeconfig.foliageProvider.getState(randomsource, pos));
            return true;
        }
        return false;
    }

    protected void tryPlaceFruit(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos) {
        foliageSetter.set(pos, ((Block)BlockRegistration.pampaperbark.get()).defaultBlockState());
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pos) {
        return pLevel.isStateAtPosition(pos, state -> !state.hasProperty((Property)LeavesBlock.PERSISTENT) || (Boolean)state.getValue((Property)LeavesBlock.PERSISTENT) == false) && TreeFeature.validTreePos((LevelSimulatedReader)pLevel, (BlockPos)pos);
    }

    static {
        CODEC = MapCodec.unit(() -> new PaperbarkFruitTrunkPlacer(((Block)BlockRegistration.pampaperbark.get()).defaultBlockState()));
    }
}

