/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.client.IHudSupport;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.ClientCommandHandler;
import mcjty.rftoolspower.modules.endergenic.EndergenicConfiguration;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EnderMonitorTileEntity;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import mcjty.rftoolspower.modules.endergenic.data.EndergenicPearl;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.Lazy;

public class EndergenicTileEntity
extends TickingTileEntity
implements IHudSupport,
TickOrderHandler.IOrderTicker {
    private static final Random random = new Random();
    public static final int CHARGE_IDLE = 0;
    public static final int CHARGE_HOLDING = -1;
    public long clientLastRfPerTick = 0L;
    public int clientLastPearlsLost = 0;
    public int clientLastPearlsLaunched = 0;
    public int clientLastPearlOpportunities = 0;
    public static final VoxelShape SHAPE = Shapes.box((double)0.002, (double)0.002, (double)0.002, (double)0.998, (double)0.998, (double)0.998);
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)EndergenicConfiguration.MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.ENERGY)
    private static final Function<EndergenicTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    private final Lazy<IMachineInformation> infoHandler = Lazy.of(this::createMachineInfo);
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<EndergenicTileEntity, IInfusable> INFUSABLE_CAP = tile -> tile.infusable;
    @Cap(type=CapType.CONTAINER)
    private static final Function<EndergenicTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Endergenic").containerSupplier(DefaultContainerProvider.empty(EndergenicModule.CONTAINER_ENDERGENIC, (GenericTileEntity)be)).energyHandler(() -> be.energyStorage);
    private int chargingMode = 0;
    private int currentAge = 0;
    private BlockPos destination = null;
    private int distance = 0;
    private boolean prevIn = false;
    private long rfGained = 0L;
    private long rfLost = 0L;
    private int pearlsLaunched = 0;
    private int pearlsLost = 0;
    private int chargeCounter = 0;
    private int pearlArrivedAt = -2;
    private int ticks = 100;
    private long lastRfPerTick = 0L;
    private long lastRfGained = 0L;
    private long lastRfLost = 0L;
    private int lastPearlsLost = 0;
    private int lastPearlsLaunched = 0;
    private int lastChargeCounter = 0;
    private int lastPearlArrivedAt = 0;
    private String lastPearlsLostReason = "";
    private List<EndergenicPearl> pearls = new ArrayList<EndergenicPearl>();
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private int badCounter = 0;
    private int goodCounter = 0;
    private static final long[] rfPerHit = new long[]{0L, 100L, 150L, 200L, 400L, 800L, 1600L, 3200L, 6400L, 8000L, 12800L, 8000L, 6400L, 2500L, 1000L, 100L};
    private int tickCounter = 0;
    private long ticker = -1L;
    public static final Direction[] HORIZ_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Key<Long> PARAM_STATRF = new Key("statrf", Type.LONG);
    public static final Key<Integer> PARAM_STATLOST = new Key("statlost", Type.INTEGER);
    public static final Key<Integer> PARAM_STATLAUNCHED = new Key("statlaunched", Type.INTEGER);
    public static final Key<Integer> PARAM_STATOPPORTUNITIES = new Key("statopportunities", Type.INTEGER);
    @ServerCommand
    public static final ResultCommand<?> CMD_GETSTATS = ResultCommand.create((String)"getStats", (te, player, params) -> TypedMap.builder().put(PARAM_STATRF, (Object)te.lastRfPerTick).put(PARAM_STATLOST, (Object)te.lastPearlsLost).put(PARAM_STATLAUNCHED, (Object)te.lastPearlsLaunched).put(PARAM_STATOPPORTUNITIES, (Object)te.lastChargeCounter).build(), (te, player, params) -> {
        te.clientLastRfPerTick = (Long)params.get(PARAM_STATRF);
        te.clientLastPearlsLost = (Integer)params.get(PARAM_STATLOST);
        te.clientLastPearlsLaunched = (Integer)params.get(PARAM_STATLAUNCHED);
        te.clientLastPearlOpportunities = (Integer)params.get(PARAM_STATOPPORTUNITIES);
    });
    public static final Key<BlockPos> PARAM_DESTINATION = new Key("dest", Type.BLOCKPOS);
    @ServerCommand
    public static final Command<?> CMD_SETDESTINATION = Command.create((String)"setDestination", (te, player, params) -> te.setDestination((BlockPos)params.get(PARAM_DESTINATION)));
    @ServerCommand
    public static final ListCommand<?, ?> CMD_GETHUDLOG = ListCommand.create((String)"getHudLog", (te, player, params) -> te.getHudLog(), (te, player, params, list) -> {
        te.clientHudLog = list;
    });

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).noOcclusion()).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/endergenic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(EndergenicTileEntity::new)){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    public EndergenicTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EndergenicModule.ENDERGENIC.be().get(), pos, state);
    }

    public void tick() {
        if (this.badCounter > 0) {
            --this.badCounter;
            this.markDirtyQuick();
        }
        if (this.goodCounter > 0) {
            --this.goodCounter;
            this.markDirtyQuick();
        }
    }

    public long getTicker() {
        return this.ticker;
    }

    public void setTicker(long ticker) {
        this.ticker = ticker;
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_1;
    }

    public Direction getBlockOrientation() {
        return null;
    }

    public boolean isBlockAboveAir() {
        return this.level.isEmptyBlock(this.worldPosition.above());
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(ChatFormatting.BLUE) + "Last 5 seconds:");
        list.add("    Charged: " + this.getLastChargeCounter());
        list.add("    Fired: " + this.getLastPearlsLaunched());
        list.add("    Lost: " + this.getLastPearlsLost());
        if (this.getLastPearlsLost() > 0) {
            list.add(String.valueOf(ChatFormatting.RED) + "    " + this.getLastPearlsLostReason());
        }
        if (this.getLastPearlArrivedAt() > -2) {
            list.add("    Last pearl at " + this.getLastPearlArrivedAt());
        }
        list.add(String.valueOf(ChatFormatting.BLUE) + "Power:");
        list.add(String.valueOf(ChatFormatting.GREEN) + "    RF Gain " + this.getLastRfGained());
        list.add(String.valueOf(ChatFormatting.RED) + "    RF Lost " + this.getLastRfLost());
        list.add(String.valueOf(ChatFormatting.GREEN) + "    RF/t " + this.getLastRfPerTick());
        return list;
    }

    public BlockPos getHudPos() {
        return this.getBlockPos();
    }

    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public int getBadCounter() {
        return this.badCounter;
    }

    public long getLastRfPerTick() {
        return this.lastRfPerTick;
    }

    public long getLastRfGained() {
        return this.lastRfGained;
    }

    public long getLastRfLost() {
        return this.lastRfLost;
    }

    public int getLastPearlsLost() {
        return this.lastPearlsLost;
    }

    public int getLastPearlsLaunched() {
        return this.lastPearlsLaunched;
    }

    public int getLastChargeCounter() {
        return this.lastChargeCounter;
    }

    public int getLastPearlArrivedAt() {
        return this.lastPearlArrivedAt;
    }

    public String getLastPearlsLostReason() {
        return this.lastPearlsLostReason;
    }

    public int getGoodCounter() {
        return this.goodCounter;
    }

    public void tickOnServer() {
        ++this.tickCounter;
        --this.ticks;
        if (this.ticks < 0) {
            this.lastRfGained = this.rfGained;
            this.lastRfLost = this.rfLost;
            this.lastRfPerTick = (this.rfGained - this.rfLost) / 100L;
            this.lastPearlsLost = this.pearlsLost;
            this.lastPearlsLaunched = this.pearlsLaunched;
            this.lastChargeCounter = this.chargeCounter;
            this.lastPearlArrivedAt = this.pearlArrivedAt;
            this.ticks = 100;
            this.rfGained = 0L;
            this.rfLost = 0L;
            this.pearlsLaunched = 0;
            this.pearlsLost = 0;
            this.chargeCounter = 0;
            this.pearlArrivedAt = -2;
        }
        this.handlePearls();
        this.handleSendingEnergy();
        if (this.chargingMode == -1 && random.nextInt(1000) <= (Integer)EndergenicConfiguration.chanceLost.get()) {
            this.log("Server Tick: discard pearl randomly");
            this.discardPearl("Random pearl discard");
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            if (this.chargingMode == 0) {
                this.log("Server Tick: pulse -> start charging");
                this.startCharging();
                return;
            }
            if (this.chargingMode == -1) {
                this.log("Server Tick: pulse -> fire pearl");
                this.firePearl();
                return;
            }
        }
        if (this.chargingMode == 0) {
            return;
        }
        if (this.chargingMode == -1) {
            long rf = ((Integer)EndergenicConfiguration.rfToHoldPearl.get()).intValue();
            rf = (long)((float)rf * (3.0f - this.infusable.getInfusedFactor()) / 3.0f);
            long rfStored = this.energyStorage.getEnergy();
            if (rfStored < rf) {
                this.log("Server Tick: insufficient energy to hold pearl (" + rfStored + " vs " + rf + ")");
                this.discardPearl("Not enough energy to hold pearl");
            } else {
                long rfExtracted = this.energyStorage.extractEnergy((int)rf, false);
                this.log("Server Tick: holding pearl, consume " + rfExtracted + " RF");
                this.rfLost += rfExtracted;
            }
            return;
        }
        this.markDirtyQuick();
        ++this.chargingMode;
        if (this.chargingMode >= 16) {
            this.log("Server Tick: charging mode ends -> idle");
            this.chargingMode = 0;
        }
    }

    @Nonnull
    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"rftick", "lost", "launched", "opportunities"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"Average RF/tick for the last 5 seconds", "Amount of pearls that were lost during the last 5 seconds", "Amount of pearls that were launched during the last 5 seconds", "Number of opportunities for the last 5 seconds"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                return switch (index) {
                    case 0 -> Long.toString(EndergenicTileEntity.this.lastRfPerTick);
                    case 1 -> Integer.toString(EndergenicTileEntity.this.lastPearlsLost);
                    case 2 -> Integer.toString(EndergenicTileEntity.this.lastPearlsLaunched);
                    case 3 -> Integer.toString(EndergenicTileEntity.this.lastChargeCounter);
                    default -> null;
                };
            }
        };
    }

    private void log(String message) {
    }

    public void modifyEnergyStored(long e) {
        long energy;
        long capacity = this.energyStorage.getCapacity();
        if (e > capacity - (energy = this.energyStorage.getEnergy())) {
            e = capacity - energy;
        } else if (e < -energy) {
            e = -energy;
        }
        this.energyStorage.setEnergy(energy += e);
    }

    private void fireMonitors(EnderMonitorMode mode) {
        BlockPos pos = this.getBlockPos();
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            Direction inputSide;
            BlockPos c = pos.relative(dir);
            BlockEntity te = this.level.getBlockEntity(c);
            if (!(te instanceof EnderMonitorTileEntity) || (inputSide = LogicSupport.getFacing((BlockState)this.level.getBlockState(c)).getInputSide()) != dir.getOpposite()) continue;
            EnderMonitorTileEntity enderMonitorTileEntity = (EnderMonitorTileEntity)te;
            enderMonitorTileEntity.fireFromEndergenic(mode);
        }
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy() - (long)((Integer)EndergenicConfiguration.ENDERGENIC_KEEPRF.get()).intValue();
        if (storedPower <= 0L) {
            return;
        }
        EnergyTools.handleSendingEnergy((Level)this.level, (BlockPos)this.worldPosition, (long)storedPower, (long)((Integer)EndergenicConfiguration.ENDERGENIC_SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    private void handlePearls() {
        if (this.pearls.isEmpty()) {
            return;
        }
        ArrayList<EndergenicPearl> newlist = new ArrayList<EndergenicPearl>();
        for (EndergenicPearl pearl : this.pearls) {
            this.log("Pearls: age=" + pearl.getAge() + ", ticks left=" + pearl.getTicksLeft());
            if (pearl.handleTick(this.level)) continue;
            newlist.add(pearl);
        }
        this.pearls = newlist;
    }

    private void markDirtyClientNoRender() {
        this.setChanged();
        if (this.level != null) {
            this.level.getEntitiesOfClass(Player.class, new AABB(this.worldPosition).inflate(32.0), p -> this.worldPosition.distToCenterSqr(p.getX(), p.getY(), p.getZ()) < 1024.0).forEach(p -> Networking.sendToPlayer((CustomPacketPayload)PacketSendClientCommand.create((String)"rftoolspower", (String)"flashEndergenic", (TypedMap)TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.getBlockPos()).put(ClientCommandHandler.PARAM_GOODCOUNTER, (Object)this.goodCounter).put(ClientCommandHandler.PARAM_BADCOUNTER, (Object)this.badCounter).build()), (Player)p));
        }
    }

    public void syncCountersFromServer(int goodCounter, int badCounter) {
        this.goodCounter = goodCounter;
        this.badCounter = badCounter;
    }

    private void discardPearl(String reason) {
        this.badCounter = 20;
        this.markDirtyClientNoRender();
        ++this.pearlsLost;
        this.lastPearlsLostReason = reason;
        this.chargingMode = 0;
        this.fireMonitors(EnderMonitorMode.MODE_LOSTPEARL);
    }

    public EndergenicTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        BlockEntity te = this.level.getBlockEntity(this.destination);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void firePearl() {
        this.markDirtyQuick();
        this.getDestinationTE();
        if (this.destination == null) {
            this.log("Fire Pearl: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl: pearl is launched to " + this.destination.getX() + "," + this.destination.getY() + "," + this.destination.getZ());
            this.chargingMode = 0;
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, this.currentAge + 1));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void firePearlFromInjector() {
        this.markDirtyQuick();
        this.getDestinationTE();
        this.chargingMode = 0;
        if (this.destination == null) {
            this.log("Fire Pearl from injector: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl from injector: pearl is launched to " + this.destination.getX() + "," + this.destination.getY() + "," + this.destination.getZ());
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, 0));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void receivePearl(int age) {
        this.fireMonitors(EnderMonitorMode.MODE_PEARLARRIVED);
        this.markDirtyQuick();
        if (this.chargingMode == -1) {
            this.log("Receive Pearl: pearl arrives but already holding -> both are lost");
            this.discardPearl("Pearl arrived while holding");
        } else if (this.chargingMode == 0) {
            this.log("Receive Pearl: pearl arrives but generator is idle -> pearl is lost");
            this.discardPearl("Pearl arrived while idle");
        } else {
            this.pearlArrivedAt = this.chargingMode;
            long rf = (long)((double)rfPerHit[this.chargingMode] * (Double)EndergenicConfiguration.powergenFactor.get());
            rf = (long)((float)rf * (this.infusable.getInfusedFactor() + 2.0f) / 2.0f);
            int a = age * 5;
            if (a > 100) {
                a = 100;
            }
            rf += rf * (long)a / 100L;
            this.rfGained += rf;
            this.log("Receive Pearl: pearl arrives at tick " + this.chargingMode + ", age=" + age + ", RF=" + rf);
            this.modifyEnergyStored(rf);
            this.goodCounter = 10;
            this.markDirtyClientNoRender();
            this.chargingMode = -1;
            this.currentAge = age;
        }
    }

    public void startCharging() {
        this.markDirtyQuick();
        this.chargingMode = 1;
        ++this.chargeCounter;
    }

    public void useWrenchClient(Player player) {
        BlockPos thisCoord = this.getBlockPos();
        BlockPos coord = RFToolsBase.instance.clientInfo.getSelectedTE();
        BlockEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.level.getBlockEntity(coord);
        }
        if (!(tileEntity instanceof EndergenicTileEntity)) {
            RFToolsBase.instance.clientInfo.setSelectedTE(thisCoord);
            EndergenicTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFToolsBase.instance.clientInfo.setDestinationTE(null);
                Logging.message((Player)player, (String)"Select another endergenic generator as destination");
            } else {
                RFToolsBase.instance.clientInfo.setDestinationTE(destinationTE.getBlockPos());
                int distance = this.getDistanceInTicks();
                Logging.message((Player)player, (String)("Select another endergenic generator as destination (current distance " + distance + ")"));
            }
        } else if (coord.equals((Object)thisCoord)) {
            RFToolsBase.instance.clientInfo.setSelectedTE(null);
            RFToolsBase.instance.clientInfo.setDestinationTE(null);
        } else {
            EndergenicTileEntity otherTE = (EndergenicTileEntity)tileEntity;
            int distance = otherTE.calculateDistance(thisCoord);
            if (distance >= 5) {
                Logging.warn((Player)player, (String)"Distance is too far (maximum 4)");
                return;
            }
            otherTE.setDestination(thisCoord);
            RFToolsBase.instance.clientInfo.setSelectedTE(null);
            RFToolsBase.instance.clientInfo.setDestinationTE(null);
            Logging.message((Player)player, (String)("Destination is set (distance " + otherTE.getDistanceInTicks() + " ticks)"));
        }
    }

    public int getChargingMode() {
        return this.chargingMode;
    }

    public int calculateDistance(BlockPos destination) {
        double d = new Vec3((double)destination.getX(), (double)destination.getY(), (double)destination.getZ()).distanceTo(new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()));
        return (int)(d / 3.0) + 1;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public void setDestination(BlockPos destination) {
        this.markDirtyQuick();
        this.destination = destination;
        this.distance = this.calculateDistance(destination);
        if (this.level.isClientSide) {
            PacketServerCommandTyped packet = PacketServerCommandTyped.create((BlockPos)this.getBlockPos(), (ResourceKey)this.getDimension(), (String)CMD_SETDESTINATION.name(), (TypedMap)TypedMap.builder().put(PARAM_DESTINATION, (Object)destination).build());
            Networking.sendToServer((CustomPacketPayload)packet);
        }
    }

    public int getDistanceInTicks() {
        return this.distance;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.chargingMode = tag.getInt("charging");
        this.currentAge = tag.getInt("age");
        this.destination = BlockPosTools.read((CompoundTag)tag, (String)"dest");
        this.distance = tag.getInt("distance");
        this.prevIn = tag.getBoolean("prevIn");
        this.badCounter = tag.getByte("bad");
        this.goodCounter = tag.getByte("good");
        this.pearls.clear();
        ListTag list = tag.getList("pearls", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tc = list.getCompound(i);
            EndergenicPearl pearl = new EndergenicPearl(tc);
            this.pearls.add(pearl);
        }
        this.energyStorage.load(tag, "energy", provider);
        this.infusable.load(tag, "infusable");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("charging", this.chargingMode);
        tag.putInt("age", this.currentAge);
        BlockPosTools.write((CompoundTag)tag, (String)"dest", (BlockPos)this.destination);
        tag.putInt("distance", this.distance);
        tag.putBoolean("prevIn", this.prevIn);
        tag.putByte("bad", (byte)this.badCounter);
        tag.putByte("good", (byte)this.goodCounter);
        ListTag pearlList = new ListTag();
        for (EndergenicPearl pearl : this.pearls) {
            pearlList.add((Object)pearl.getTagCompound());
        }
        tag.put("pearls", (Tag)pearlList);
        this.energyStorage.save(tag, "energy", provider);
        this.infusable.save(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
    }

    public boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        if (world.isClientSide) {
            SoundEvent pling = Tools.getSound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block.note_block.pling"));
            world.playSound(player, pos, pling, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.useWrenchClient(player);
        }
        return true;
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    public IMachineInformation getInfoHandler() {
        return (IMachineInformation)this.infoHandler.get();
    }
}

