/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.su5ed.mffs.render.particle.ParticleColor;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamParticle
extends Particle {
    private static final ResourceLocation FORTRON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mffs", (String)"textures/particle/fortron.png");
    private static final int ROTATION_SPEED = 20;
    private static final boolean PULSE = true;
    private final float length;
    private final float rotYaw;
    private final float rotPitch;
    private final float prevYaw;
    private final float prevPitch;
    private float prevSize;

    public BeamParticle(ClientLevel level, Vec3 start, Vec3 target, ParticleColor color, int lifetime) {
        super(level, start.x(), start.y(), start.z(), 0.0, 0.0, 0.0);
        this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        this.setSize(0.02f, 0.02f);
        this.setBoundingBox(new AABB(start, target));
        this.setLifetime(lifetime);
        this.xd = this.xo - target.x();
        this.yd = this.yo - target.y();
        this.zd = this.zo - target.z();
        this.length = (float)start.distanceTo(target);
        this.rotYaw = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        double destX = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.rotPitch = (float)(Math.atan2(this.yd, destX) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Matrix4f mat = new Matrix4f();
        mat.identity();
        int deg = 18;
        float rot = (float)(this.level.getGameTime() % (long)deg * 20L) + 20.0f * partialTicks;
        float size = 1.0f;
        size = Math.min((float)this.age / 4.0f, 1.0f);
        size = Mth.lerp((float)partialTicks, (float)this.prevSize, (float)size);
        float opacity = 0.5f;
        if (this.lifetime - this.age <= 4) {
            opacity = 0.5f - (float)(4 - (this.lifetime - this.age)) * 0.1f;
        }
        float tickSlide = (float)this.level.getGameTime() + partialTicks;
        float vOffset = -tickSlide * 0.2f - (float)Mth.floor((float)(-tickSlide * 0.1f));
        Vec3 vec3 = renderInfo.getPosition();
        float xx = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float yy = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float zz = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        mat.translate((Vector3fc)new Vector3f(xx, yy, zz));
        float ry = Mth.lerp((float)partialTicks, (float)this.prevYaw, (float)this.rotYaw);
        float rp = Mth.lerp((float)partialTicks, (float)this.prevPitch, (float)this.rotPitch);
        mat.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        mat.rotate((Quaternionfc)Axis.ZN.rotationDegrees(180.0f + ry));
        mat.rotate((Quaternionfc)Axis.XP.rotationDegrees(rp));
        float xNegMin = -0.15f * size;
        float xNegMax = -0.15f * size;
        float xPosMin = 0.15f * size;
        float xPosMax = 0.15f * size;
        float yMax = this.length * size;
        Vector3f[] vectors = new Vector3f[]{new Vector3f(xNegMax, yMax, 0.0f), new Vector3f(xNegMin, 0.0f, 0.0f), new Vector3f(xPosMin, 0.0f, 0.0f), new Vector3f(xPosMax, yMax, 0.0f)};
        float u0 = 0.0f;
        float u1 = 1.0f;
        int brightness = 0xF000F0;
        mat.rotate((Quaternionfc)Axis.YP.rotationDegrees(rot));
        for (int i = 0; i < 3; ++i) {
            float v0 = -1.0f + vOffset + (float)i / 3.0f;
            float v1 = this.length * size + v0;
            mat.rotate((Quaternionfc)Axis.YP.rotationDegrees(60.0f));
            buffer.addVertex(mat, vectors[0].x(), vectors[0].y(), vectors[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, opacity).setLight(brightness);
            buffer.addVertex(mat, vectors[1].x(), vectors[1].y(), vectors[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, opacity).setLight(brightness);
            buffer.addVertex(mat, vectors[2].x(), vectors[2].y(), vectors[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, opacity).setLight(brightness);
            buffer.addVertex(mat, vectors[3].x(), vectors[3].y(), vectors[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, opacity).setLight(brightness);
        }
        this.prevSize = size;
    }

    public ParticleRenderType getRenderType() {
        return BeamParticleRenderType.INSTANCE;
    }

    public static class BeamParticleRenderType
    implements ParticleRenderType {
        public static final BeamParticleRenderType INSTANCE = new BeamParticleRenderType();

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FORTRON_TEXTURE);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }
    }
}

