/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.datatypes;

import com.direwolf20.buildinggadgets2.datagen.BG2BlockTags;
import com.direwolf20.buildinggadgets2.util.VecHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TemplateJsonRepresentation {
    public static final int B1_BYTE_MASK = 255;
    public static final int B2_BYTE_MASK = 65535;
    public static final int B3_BYTE_MASK = 0xFFFFFF;
    public final JsonObject header;
    public final String body;

    private TemplateJsonRepresentation(JsonObject header, String body) {
        this.header = header;
        this.body = body;
    }

    public static ArrayList<StatePos> deserialize(CompoundTag nbt, BlockPos startPos, BlockPos endPos) {
        ArrayList<StatePos> statePosList = new ArrayList<StatePos>();
        ListTag posList = nbt.getList("pos", 4);
        ListTag stateList = nbt.getList("data", 10);
        HashMap<BlockPos, BlockState> tempMap = new HashMap<BlockPos, BlockState>();
        for (Tag inbt : posList) {
            LongTag longNBT = (LongTag)inbt;
            BlockPos pos2 = TemplateJsonRepresentation.posFromLong(longNBT.getAsLong());
            int stateID = TemplateJsonRepresentation.readStateId(longNBT.getAsLong());
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)stateList.getCompound(stateID).getCompound("state"));
            tempMap.put(pos2, blockState);
        }
        AABB area = VecHelpers.aabbFromBlockPos(startPos, endPos);
        BlockPos.betweenClosedStream((AABB)area).map(BlockPos::immutable).forEach(pos -> {
            BlockState blockState = tempMap.getOrDefault(pos, Blocks.AIR.defaultBlockState());
            if (blockState.isAir()) {
                statePosList.add(new StatePos(blockState, (BlockPos)pos));
                return;
            }
            if (blockState.is(BG2BlockTags.BG2DENY)) {
                statePosList.add(new StatePos(Blocks.AIR.defaultBlockState(), (BlockPos)pos));
                return;
            }
            if (blockState.getBlock().defaultDestroyTime() < 0.0f) {
                statePosList.add(new StatePos(Blocks.AIR.defaultBlockState(), (BlockPos)pos));
                return;
            }
            if (!blockState.getFluidState().isEmpty() && !blockState.getFluidState().isSource()) {
                statePosList.add(new StatePos(Blocks.AIR.defaultBlockState(), (BlockPos)pos));
                return;
            }
            statePosList.add(new StatePos(blockState, (BlockPos)pos));
        });
        return statePosList;
    }

    public static BlockPos posFromLong(long serialized) {
        int x = (int)(serialized >> 24 & 0xFFFFL);
        int y = (int)(serialized >> 16 & 0xFFL);
        int z = (int)(serialized & 0xFFFFL);
        return new BlockPos(x, y, z);
    }

    public static int readStateId(long serialized) {
        return (int)(serialized >> 40 & 0xFFFFFFL);
    }
}

