/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MagicHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class HorizontalWall
extends BaseMode {
    public HorizontalWall() {
        super(false);
    }

    @Override
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"buildinggadgets2", (String)"horizontal_wall");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        ItemStack gadget = BaseGadget.getGadget(player);
        int range = GadgetNBT.getToolRange(gadget);
        int halfRange = range / 2;
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        boolean placeontop = GadgetNBT.getSetting(gadget, GadgetNBT.ToggleableSettings.PLACE_ON_TOP.getName());
        if (hitSide.getAxis() == Direction.Axis.Y) {
            for (int i = -halfRange; i <= halfRange; ++i) {
                for (int j = -halfRange; j <= halfRange; ++j) {
                    BlockPos coord = new BlockPos(start.getX() - i, start.getY() + (placeontop ? 1 : 0), start.getZ() + j);
                    if (!this.isPosValid(player.level(), player, coord, state)) continue;
                    coordinates.add(new StatePos(state, coord.subtract((Vec3i)start)));
                }
            }
            return coordinates;
        }
        Direction.Axis axis = hitSide.getAxis();
        for (int i = 1; i < range + 1; ++i) {
            for (int j = -halfRange; j <= halfRange; ++j) {
                BlockPos coord;
                int value = MagicHelpers.invertOnFace(hitSide, i);
                if (!this.isPosValid(player.level(), player, start.relative(hitSide, i), state)) continue;
                BlockPos blockPos = coord = axis == Direction.Axis.X ? new BlockPos(start.getX() + value, start.getY(), start.getZ() + j) : new BlockPos(start.getX() + j, start.getY(), start.getZ() + value);
                if (!this.isPosValid(player.level(), player, coord, state)) continue;
                coordinates.add(new StatePos(state, coord.subtract((Vec3i)start)));
            }
        }
        return coordinates;
    }
}

