/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.network.VanillaPacketDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class FilteringShelfBlock
extends ChiseledBookShelfBlock
implements EnchantmentStatBlock {
    public FilteringShelfBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public Set<Holder<Enchantment>> getBlacklistedEnchantments(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            HashSet<Holder<Enchantment>> blacklist = new HashSet<Holder<Enchantment>>();
            for (ItemStack s : shelf.getEnchantedBooks()) {
                Holder ench;
                ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)s);
                if (enchants.size() != 1 || (ench = (Holder)enchants.keySet().stream().findFirst().orElse(null)) == null) continue;
                blacklist.add((Holder<Enchantment>)ench);
            }
            return blacklist;
        }
        return Collections.emptySet();
    }

    @Override
    public float getMaxEnchantingPower(BlockState state, LevelReader world, BlockPos pos) {
        return 30.0f;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            return (float)shelf.getEnchantedBooks().size() * 0.5f;
        }
        return 0.0f;
    }

    @Override
    public float getArcanaBonus(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof FilteringShelfTile) {
            FilteringShelfTile shelf = (FilteringShelfTile)be;
            return shelf.getEnchantedBooks().size();
        }
        return 0.0f;
    }

    @Override
    public ParticleOptions getTableParticle(BlockState state) {
        return Ench.Particles.ENCHANT_WATER;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity shelf = (ChiseledBookShelfBlockEntity)be;
            if (!FilteringShelfBlock.canInsert(stack)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            OptionalInt slot = this.getHitSlot(hitResult, state);
            if (slot.isEmpty()) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (((Boolean)state.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(slot.getAsInt()))).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            FilteringShelfBlock.addBook((Level)level, (BlockPos)pos, (Player)player, (ChiseledBookShelfBlockEntity)shelf, (ItemStack)stack, (int)slot.getAsInt());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FilteringShelfTile(pPos, pState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)TooltipUtil.lang("info", "filtering_shelf", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public static boolean canInsert(ItemStack stack) {
        return stack.is(ItemTags.BOOKSHELF_BOOKS);
    }

    public static boolean isEnchantedBook(ItemStack stack) {
        return stack.is(Items.ENCHANTED_BOOK) && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).size() == 1;
    }

    public static class FilteringShelfTile
    extends ChiseledBookShelfBlockEntity {
        public FilteringShelfTile(BlockPos pPos, BlockState pState) {
            super(pPos, pState);
        }

        public boolean canPlaceItem(int pIndex, ItemStack pStack) {
            return FilteringShelfBlock.canInsert(pStack);
        }

        public BlockEntityType<?> getType() {
            return Ench.Tiles.FILTERING_SHELF.get();
        }

        public List<ItemStack> getBooks() {
            ArrayList<ItemStack> books = new ArrayList<ItemStack>();
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                books.add(stack);
            }
            return books;
        }

        public List<ItemStack> getEnchantedBooks() {
            return this.getBooks().stream().filter(FilteringShelfBlock::isEnchantedBook).toList();
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            this.saveAdditional(tag, registries);
            return tag;
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
            this.loadAdditional(pkt.getTag(), registries);
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public void setItem(int pSlot, ItemStack pStack) {
            super.setItem(pSlot, pStack);
            if (!this.level.isClientSide) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
            }
        }
    }
}

