/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.Validate;

public record AmadronTradeResource(Either<ItemStack, FluidStack> resource) {
    public static final Codec<AmadronTradeResource> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.either((Codec)ItemStack.CODEC, (Codec)FluidStack.CODEC).fieldOf("resource").forGetter(AmadronTradeResource::resource)).apply((Applicative)inst, AmadronTradeResource::new));
    public static StreamCodec<RegistryFriendlyByteBuf, AmadronTradeResource> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)ItemStack.STREAM_CODEC, (StreamCodec)FluidStack.STREAM_CODEC), AmadronTradeResource::resource, AmadronTradeResource::new);

    public boolean isEmpty() {
        return (Boolean)this.resource.map(ItemStack::isEmpty, FluidStack::isEmpty);
    }

    public boolean equivalentTo(AmadronTradeResource other) {
        return (Boolean)this.resource.map(itemStack -> itemStack.getItem() == other.getItem().getItem(), fluidStack -> fluidStack.getFluid() == other.getFluid().getFluid());
    }

    public static AmadronTradeResource of(ItemStack stack) {
        return new AmadronTradeResource((Either<ItemStack, FluidStack>)Either.left((Object)stack));
    }

    public static AmadronTradeResource of(FluidStack stack) {
        return new AmadronTradeResource((Either<ItemStack, FluidStack>)Either.right((Object)stack));
    }

    public ItemStack getItem() {
        return this.resource.left().orElse(ItemStack.EMPTY);
    }

    public FluidStack getFluid() {
        return this.resource.right().orElse(FluidStack.EMPTY);
    }

    public void accept(Consumer<ItemStack> cItemStack, Consumer<FluidStack> cFluidStack) {
        this.resource.ifLeft(cItemStack).ifRight(cFluidStack);
    }

    public <T> T apply(Function<ItemStack, T> fItemStack, Function<FluidStack, T> fFluidStack) {
        return (T)this.resource.map(fItemStack, fFluidStack);
    }

    public int totalSpaceRequired(int units) {
        return (Integer)this.resource.map(itemStack -> (itemStack.getCount() * units - 1) / itemStack.getMaxStackSize() + 1, fluidStack -> fluidStack.getAmount() * units);
    }

    public int countTradesInInventory(IItemHandler inv) {
        return this.resource.left().map(item -> AmadronTradeResource.countItemsInHandler(item, inv) / item.getCount()).orElse(0);
    }

    public int findSpaceInItemOutput(IItemHandler inv, int wantedTradeCount) {
        return this.resource.left().map(item -> Math.min(wantedTradeCount, AmadronTradeResource.findSpaceInHandler(item, wantedTradeCount, inv))).orElse(0);
    }

    public int countTradesInTank(IFluidHandler fluidHandler) {
        return this.resource.right().map(fluid -> {
            FluidStack searchingFluid = fluid.copy();
            searchingFluid.setAmount(Integer.MAX_VALUE);
            FluidStack extracted = fluidHandler.drain(searchingFluid, IFluidHandler.FluidAction.SIMULATE);
            return extracted.getAmount() / fluid.getAmount();
        }).orElse(0);
    }

    public int findSpaceInFluidOutput(IFluidHandler fluidHandler, int wantedTradeCount) {
        return this.resource.right().map(fluid -> {
            FluidStack providingFluid = fluid.copy();
            providingFluid.setAmount(providingFluid.getAmount() * wantedTradeCount);
            int amountFilled = fluidHandler.fill(providingFluid, IFluidHandler.FluidAction.SIMULATE);
            return amountFilled / fluid.getAmount();
        }).orElse(0);
    }

    public AmadronTradeResource validate() {
        this.resource.ifLeft(stack -> Validate.isTrue((!stack.isEmpty() ? 1 : 0) != 0)).ifRight(fluidStack -> Validate.isTrue((!fluidStack.isEmpty() ? 1 : 0) != 0));
        return this;
    }

    public String getName() {
        return (String)this.resource.map(itemStack -> itemStack.getHoverName().getString(), fluidStack -> fluidStack.getHoverName().getString());
    }

    public ResourceLocation getId() {
        return (ResourceLocation)this.resource.map(itemStack -> BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()), fluidStack -> BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()));
    }

    public int getAmount() {
        return (Integer)this.resource.map(ItemStack::getCount, FluidStack::getAmount);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronTradeResource)) {
            return false;
        }
        AmadronTradeResource that = (AmadronTradeResource)o;
        return (Boolean)this.resource.map(itemStack -> ItemStack.matches((ItemStack)itemStack, (ItemStack)that.getItem()), fluidStack -> FluidStack.matches((FluidStack)fluidStack, (FluidStack)that.getFluid()));
    }

    @Override
    public int hashCode() {
        return (Integer)this.resource.map(xva$0 -> Objects.hash(xva$0), xva$0 -> Objects.hash(xva$0));
    }

    @Override
    public String toString() {
        return (String)this.resource.map(itemStack -> itemStack.getCount() + " x " + itemStack.getHoverName().getString(), fluidStack -> fluidStack.getAmount() + "mB " + fluidStack.getHoverName().getString());
    }

    private static int countItemsInHandler(ItemStack item, IItemHandler itemHandler) {
        boolean matchComponents = !item.getComponentsPatch().isEmpty();
        IItemRegistry registry = PneumaticRegistry.getInstance().getItemRegistry();
        return IntStream.range(0, itemHandler.getSlots()).filter(i -> registry.doesItemMatchFilter(item, itemHandler.getStackInSlot(i), false, matchComponents, false)).map(i -> itemHandler.getStackInSlot(i).getCount()).sum();
    }

    private static int findSpaceInHandler(ItemStack item, int multiplier, IItemHandler itemHandler) {
        int totalItems;
        int remaining = totalItems = item.getCount() * multiplier;
        for (int i = 0; i < itemHandler.getSlots() && remaining > 0; ++i) {
            if (!itemHandler.getStackInSlot(i).isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)itemHandler.getStackInSlot(i), (ItemStack)item)) continue;
            remaining -= item.getMaxStackSize() - itemHandler.getStackInSlot(i).getCount();
        }
        return (totalItems - remaining) / item.getCount();
    }
}

