/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.drone;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.drone.debug.IDroneDebugger;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface IDrone {
    public int getUpgrades(PNCUpgrade var1);

    public Level getDroneLevel();

    public FluidTank getFluidTank();

    public IEnergyStorage getEnergyStorage();

    public IItemHandlerModifiable getInv();

    public Vec3 getDronePos();

    public BlockPos getControllerPos();

    public IPathNavigator getPathNavigator();

    public void sendWireframeToClient(BlockPos var1);

    public FakePlayer getFakePlayer();

    public boolean isBlockValidPathfindBlock(BlockPos var1);

    public void dropItem(ItemStack var1);

    public void setDugBlock(@Nullable BlockPos var1);

    public void setDugBlock(@NotNull BlockPos var1, Direction var2);

    public GoalSelector getTargetAI();

    public void setEmittingRedstone(Direction var1, int var2);

    public int getEmittingRedstone(Direction var1);

    public void setName(Component var1);

    public void setCarryingEntity(Entity var1);

    public List<Entity> getCarryingEntities();

    public boolean isAIOverridden();

    public void onItemPickupEvent(ItemEntity var1, int var2);

    public Player getOwner();

    @Nonnull
    public UUID getOwnerUUID();

    public BlockPos getDeployPos();

    public List<IProgWidget> getProgWidgets();

    public void setActiveProgram(IProgWidget var1);

    public boolean isProgramApplicable(ProgWidgetType<?> var1);

    public void overload(String var1, Object ... var2);

    public void updateLabel();

    public void playSound(SoundEvent var1, SoundSource var2, float var3, float var4);

    public void addAirToDrone(int var1);

    default public void onVariableChanged(String varname, boolean isCoordinate) {
    }

    public int getActiveWidgetIndex();

    public IDroneDebugger getDebugger();

    public void storeTrackerData(ItemStack var1);

    default public IProgWidget getActiveWidget() {
        int index = this.getActiveWidgetIndex();
        if (index >= 0 && index < this.getProgWidgets().size()) {
            return this.getProgWidgets().get(index);
        }
        return null;
    }

    public String getLabel();

    public Component getDroneName();

    public boolean isDroneStillValid();

    public boolean canMoveIntoFluid(Fluid var1);

    default public void resetAttackCount() {
    }

    public float getDronePressure();
}

