/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import java.util.Optional;
import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.TemperatureListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface IHeatExchangerLogic {
    public static final BiPredicate<LevelAccessor, BlockPos> ALL_BLOCKS = (world, pos) -> true;

    public void tick();

    public void initializeAsHull(Level var1, BlockPos var2, BiPredicate<LevelAccessor, BlockPos> var3, Direction ... var4);

    public void initializeAmbientTemperature(Level var1, BlockPos var2);

    default public void addConnectedExchanger(IHeatExchangerLogic exchanger) {
        this.addConnectedExchanger(exchanger, true);
    }

    @ApiStatus.Internal
    default public void addConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
    }

    default public void removeConnectedExchanger(IHeatExchangerLogic exchanger) {
        this.removeConnectedExchanger(exchanger, true);
    }

    @ApiStatus.Internal
    default public void removeConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
    }

    public void setTemperature(double var1);

    public double getTemperature();

    public int getTemperatureAsInt();

    public double getAmbientTemperature();

    public void setThermalResistance(double var1);

    public double getThermalResistance();

    public void setThermalCapacity(double var1);

    public double getThermalCapacity();

    public void addHeat(double var1);

    public boolean isSideConnected(Direction var1);

    default public void addTemperatureListener(@NotNull TemperatureListener listener) {
    }

    default public void removeTemperatureListener(@NotNull TemperatureListener listener) {
    }

    default public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    default public void deserializeNBT(CompoundTag nbt) {
    }

    default public <T extends HeatBehaviour> Optional<T> getHeatBehaviour(BlockPos pos, Class<T> cls) {
        return Optional.empty();
    }
}

