/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.IGuiDrone;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.SavedDroneProgram;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.apache.commons.lang3.mutable.MutableBoolean;

@EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class TooltipEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof BucketItem) {
            TooltipEventHandler.handleFluidContainerTooltip(event);
        } else if (PneumaticCraftUtils.getRegistryName(stack.getItem()).orElseThrow().getNamespace().equals("pneumaticcraft") || stack.is(PneumaticCraftTags.Items.PNC_TOOLTIP)) {
            TooltipEventHandler.addStandardTooltip(stack, event.getToolTip(), event.getFlags());
        }
        Item item = stack.getItem();
        if (item instanceof IProgrammable) {
            IProgrammable programmable = (IProgrammable)item;
            TooltipEventHandler.handleProgrammableTooltip(event, programmable);
        }
    }

    private static void addStandardTooltip(ItemStack stack, List<Component> curInfo, TooltipFlag flagIn) {
        String key;
        TooltipEventHandler.addPressureTooltip(stack, curInfo);
        UpgradableItemUtils.addUpgradeInformation(stack, curInfo, flagIn);
        Item item = stack.getItem();
        if (item instanceof IInventoryItem) {
            IInventoryItem item2 = (IInventoryItem)item;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            item2.getStacksInItem(stack, stacks);
            if (item2.getInventoryHeader() != null && !stacks.isEmpty()) {
                curInfo.add(item2.getInventoryHeader());
            }
            PneumaticCraftUtils.summariseItemStacks(curInfo, stacks, Component.literal((String)item2.getTooltipPrefix(stack)));
        }
        if (I18n.exists((String)(key = ICustomTooltipName.getTranslationKey(stack, true)))) {
            if (ClientUtils.hasShiftDown()) {
                String translatedInfo = String.valueOf(ChatFormatting.AQUA) + I18n.get((String)key, (Object[])new Object[0]);
                curInfo.addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo)));
                if (!ThirdPartyManager.instance().getDocsProvider().isInstalled()) {
                    curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.installDocsProvider", new Object[0]));
                }
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.sneakForInfo", new Object[0]).withStyle(ChatFormatting.AQUA));
            }
        }
    }

    private static void addPressureTooltip(ItemStack stack, List<Component> textList) {
        PNCCapabilities.getAirHandler(stack).ifPresent(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            ChatFormatting color = f < 0.1f ? ChatFormatting.RED : (f < 0.5f ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN);
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 1)).withStyle(color));
        });
    }

    private static void handleProgrammableTooltip(ItemTooltipEvent event, IProgrammable programmable) {
        if (programmable.canProgram(event.getItemStack()) && programmable.showProgramTooltip()) {
            MutableBoolean hasInvalidPrograms = new MutableBoolean(false);
            ArrayList<Component> addedEntries = new ArrayList<Component>();
            SavedDroneProgram program = SavedDroneProgram.fromItemStack(event.getItemStack());
            program.summarize().forEach((widgetType, count) -> {
                ChatFormatting[] prefix = new ChatFormatting[]{};
                if (widgetType != null) {
                    IGuiDrone guiDrone;
                    Screen curScreen = Minecraft.getInstance().screen;
                    if (curScreen instanceof IGuiDrone && !(guiDrone = (IGuiDrone)curScreen).getDrone().isProgramApplicable((ProgWidgetType<?>)widgetType)) {
                        prefix = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
                        hasInvalidPrograms.setTrue();
                    }
                    addedEntries.add((Component)Component.literal((String)("\u2022 " + count + " x ")).append((Component)PneumaticCraftUtils.xlate(widgetType.getTranslationKey(), new Object[0])).withStyle(prefix));
                }
            });
            if (hasInvalidPrograms.booleanValue()) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.invalidPieces", new Object[0]).withStyle(ChatFormatting.RED));
            }
            addedEntries.sort(Comparator.comparing(Component::getString));
            event.getToolTip().addAll(addedEntries);
            if (ClientUtils.hasShiftDown() && !program.isEmpty()) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.requiredPieces", program.getRequiredPuzzlePieces()).withStyle(ChatFormatting.GREEN));
            }
        }
    }

    private static void handleFluidContainerTooltip(ItemTooltipEvent event) {
        FluidUtil.getFluidContained((ItemStack)event.getItemStack()).ifPresent(fluidStack -> {
            String key = ICustomTooltipName.getTranslationKey(event.getItemStack(), true);
            if (I18n.exists((String)key)) {
                if (Screen.hasShiftDown()) {
                    String translatedInfo = String.valueOf(ChatFormatting.AQUA) + I18n.get((String)key, (Object[])new Object[0]);
                    event.getToolTip().addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo)));
                } else {
                    event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.sneakForInfo", new Object[0]).withStyle(ChatFormatting.AQUA));
                }
            }
        });
    }

    @SubscribeEvent
    public static void gatherComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof MicromissilesItem && MicromissilesItem.getFireMode(stack) == MicromissilesItem.FireMode.SMART) {
            event.getTooltipElements().add(Either.right((Object)new MicromissilesItem.Tooltip(stack)));
        }
    }
}

