/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.AirCannonBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AirCannonMenu;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AirCannonScreen
extends AbstractPneumaticCraftContainerScreen<AirCannonMenu, AirCannonBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private WidgetAnimatedStat strengthTab;
    private int gpsX;
    private int gpsY;
    private int gpsZ;

    public AirCannonScreen(AirCannonMenu container, Inventory inventoryPlayer, Component displayName) {
        super(container, inventoryPlayer, displayName);
        this.gpsX = ((AirCannonBlockEntity)this.te).gpsX;
        this.gpsY = ((AirCannonBlockEntity)this.te).gpsY;
        this.gpsZ = ((AirCannonBlockEntity)this.te).gpsZ;
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.AIR_CANNON.get()), Short.MIN_VALUE, false);
        this.strengthTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.force", ((AirCannonBlockEntity)this.te).forceMult), new ItemStack((ItemLike)ModItems.AIR_CANISTER.get()), -14647041, false);
        this.strengthTab.setMinimumExpandedDimensions(85, 40);
        this.strengthTab.addSubWidget((AbstractWidget)new WidgetButtonExtended(16, 16, 20, 20, "--").withTag("--"));
        this.strengthTab.addSubWidget((AbstractWidget)new WidgetButtonExtended(38, 16, 20, 20, "-").withTag("-"));
        this.strengthTab.addSubWidget((AbstractWidget)new WidgetButtonExtended(60, 16, 20, 20, "+").withTag("+"));
        this.strengthTab.addSubWidget((AbstractWidget)new WidgetButtonExtended(82, 16, 20, 20, "++").withTag("++"));
        this.addLabel((Component)Component.literal((String)"GPS"), this.leftPos + 50, this.topPos + 20);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AIR_CANNON;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.statusStat.setText(this.getStatusText());
        this.strengthTab.setMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.force", ((AirCannonBlockEntity)this.te).forceMult));
        if (this.gpsX != ((AirCannonBlockEntity)this.te).gpsX || this.gpsY != ((AirCannonBlockEntity)this.te).gpsY || this.gpsZ != ((AirCannonBlockEntity)this.te).gpsZ) {
            this.gpsX = ((AirCannonBlockEntity)this.te).gpsX;
            this.gpsY = ((AirCannonBlockEntity)this.te).gpsY;
            this.gpsZ = ((AirCannonBlockEntity)this.te).gpsZ;
            this.statusStat.openStat();
        }
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        if (((AirCannonBlockEntity)this.te).gpsX != 0 || ((AirCannonBlockEntity)this.te).gpsY != 0 || ((AirCannonBlockEntity)this.te).gpsZ != 0) {
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.coord", ((AirCannonBlockEntity)this.te).gpsX, ((AirCannonBlockEntity)this.te).gpsY, ((AirCannonBlockEntity)this.te).gpsZ).withStyle(ChatFormatting.BLACK));
        } else {
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.no_coord", new Object[0]).withStyle(ChatFormatting.BLACK));
        }
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.heading", Math.round(((AirCannonBlockEntity)this.te).rotationAngle)).withStyle(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.height", Math.round(((AirCannonBlockEntity)this.te).heightAngle)).withStyle(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.airCannon.range", Math.round(((AirCannonBlockEntity)this.te).getForce() * 25.0f)).withStyle(ChatFormatting.BLACK));
        return text;
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((AirCannonBlockEntity)this.te).hasNoConnectedAirHandlers()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.airLeak", new Object[0]));
        }
        if (((Slot)((AirCannonMenu)this.menu).slots.get(5)).getItem().isEmpty() && ((AirCannonBlockEntity)this.te).getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) == 0) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.air_cannon.no_items", new Object[0]));
        }
        if (!((AirCannonBlockEntity)this.te).hasCoordinate()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.air_cannon.no_coordinate", new Object[0]));
        } else if (!((AirCannonBlockEntity)this.te).coordWithinReach) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.air_cannon.out_of_range", new Object[0]));
        } else if (((AirCannonBlockEntity)this.te).getRedstoneMode() == 0 && !((AirCannonBlockEntity)this.te).doneTurning) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.air_cannon.still_turning", new Object[0]));
        } else if (((AirCannonBlockEntity)this.te).getRedstoneMode() == 2 && !((AirCannonBlockEntity)this.te).insertingInventoryHasSpace) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.air_cannon.inv_space", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
    }

    @Override
    protected void addInformation(List<Component> curInfo) {
        super.addInformation(curInfo);
        if (curInfo.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.apply_redstone", new Object[0]));
        }
    }
}

