/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.tubemodule.PressureGaugeModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SimplePressureGaugeModuleScreen
extends AbstractTubeModuleScreen<AbstractTubeModule> {
    private WidgetTextFieldNumber thresholdField;
    private WidgetButtonExtended moreOrLessButton;

    SimplePressureGaugeModuleScreen(AbstractTubeModule module) {
        super(module);
        this.ySize = 57;
    }

    @Override
    public void init() {
        super.init();
        this.addLabel(this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.guiTop + 5);
        WidgetCheckBox advancedMode = ((WidgetCheckBox)new WidgetCheckBox(this.guiLeft + 6, this.guiTop + 20, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.advancedConfig", new Object[0]), b -> {
            this.module.advancedConfig = true;
            NetworkHandler.sendToServer(PacketUpdatePressureModule.forModule(this.module));
        }).setTooltipKey("pneumaticcraft.gui.tubeModule.advancedConfig.tooltip")).setChecked(false);
        this.addRenderableWidget((GuiEventListener)advancedMode);
        Objects.requireNonNull(this.font);
        this.thresholdField = new WidgetTextFieldNumber(this.font, this.guiLeft + 105, this.guiTop + 35, 30, 9 + 2).setDecimals(1).setAdjustments(0.1, 1.0);
        this.addRenderableWidget((GuiEventListener)this.thresholdField);
        this.thresholdField.setWidth(40);
        this.setInitialFocus((GuiEventListener)this.thresholdField);
        if (this.module instanceof AbstractRedstoneReceivingModule) {
            this.thresholdField.setValue(((AbstractRedstoneReceivingModule)this.module).getThreshold());
            MutableComponent s = PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.simpleConfig.threshold", new Object[0]);
            this.addLabel((Component)s, this.guiLeft + 80 - this.font.width((FormattedText)s), this.guiTop + 36);
        } else {
            this.thresholdField.setValue(this.module.lowerBound);
            MutableComponent s = PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.simpleConfig.turn", new Object[0]);
            this.addLabel((Component)s, this.guiLeft + 80 - this.font.width((FormattedText)s), this.guiTop + 36);
            this.moreOrLessButton = new WidgetButtonExtended(this.guiLeft + 85, this.guiTop + 33, 16, 16, this.module.lowerBound < this.module.higherBound ? ">" : "<", b -> this.flipThreshold());
            this.moreOrLessButton.setTooltipText((Component)PneumaticCraftUtils.xlate(this.module.lowerBound < this.module.higherBound ? "pneumaticcraft.gui.tubeModule.simpleConfig.higherThan" : "pneumaticcraft.gui.tubeModule.simpleConfig.lowerThan", new Object[0]));
            this.addRenderableWidget((GuiEventListener)this.moreOrLessButton);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.general.bar", new Object[0]), this.thresholdField.getX() + this.thresholdField.getWidth() + 3, this.thresholdField.getY() + 1);
    }

    private void flipThreshold() {
        float temp = this.module.higherBound;
        this.module.higherBound = this.module.lowerBound;
        this.module.lowerBound = temp;
        this.updateThreshold();
        this.moreOrLessButton.setMessage((Component)Component.literal((String)(this.module.lowerBound < this.module.higherBound ? ">" : "<")));
        this.moreOrLessButton.setTooltipText((Component)PneumaticCraftUtils.xlate(this.module.lowerBound < this.module.higherBound ? "pneumaticcraft.gui.tubeModule.simpleConfig.higherThan" : "pneumaticcraft.gui.tubeModule.simpleConfig.lowerThan", new Object[0]));
        NetworkHandler.sendToServer(PacketUpdatePressureModule.forModule(this.module));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.module.advancedConfig) {
            this.module.lowerBound = (float)this.thresholdField.getDoubleValue();
            this.minecraft.setScreen((Screen)new PressureGaugeModuleScreen(this.module));
        }
    }

    private void updateThreshold() {
        boolean moreThanMode = this.module.lowerBound > this.module.higherBound;
        this.module.lowerBound = (float)this.thresholdField.getDoubleValue();
        this.module.higherBound = moreThanMode ? this.module.lowerBound - 0.1f : this.module.lowerBound + 0.1f;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.thresholdField.isFocused()) {
            this.removed();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void removed() {
        this.updateThreshold();
        NetworkHandler.sendToServer(PacketUpdatePressureModule.forModule(this.module));
        super.removed();
    }
}

