/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public enum PneumaticArmorLayerColors implements IClientItemExtensions
{
    INSTANCE;


    public int getArmorLayerTintColor(ItemStack stack, LivingEntity entity, ArmorMaterial.Layer layer, int layerIdx, int fallbackColor) {
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem armor = (PneumaticArmorItem)item;
            return switch (layerIdx) {
                case 0 -> armor.getPrimaryColor(stack);
                case 1 -> armor.getSecondaryColor(stack);
                case 2 -> {
                    if (armor.getEquipmentSlot() == EquipmentSlot.HEAD) {
                        yield armor.getEyepieceColor(stack);
                    }
                    yield 0;
                }
                case 3 -> {
                    if (armor.getEquipmentSlot() == EquipmentSlot.CHEST) {
                        yield -1;
                    }
                    yield 0;
                }
                default -> -1;
            };
        }
        return fallbackColor;
    }

    public int getDefaultDyeColor(ItemStack stack) {
        return -1;
    }
}

