/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.common.tubemodules.VacuumModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class VacuumRenderer
extends AbstractTubeModuleRenderer<VacuumModule> {
    private static final int BLADE_COUNT = 6;
    private final ModelPart mainPart;
    private final ModelPart blade;
    private static final String MAIN = "main";
    private static final String BLADE = "blade";

    public VacuumRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(PNCModelLayers.VACUUM_MODULE);
        this.mainPart = root.getChild(MAIN);
        this.blade = root.getChild(BLADE);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(MAIN, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -7.0f, 8.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-3.0f, -11.0f, 3.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(20, 14).addBox(3.0f, -11.0f, 3.0f, 1.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(28, 14).addBox(-4.0f, -11.0f, 3.0f, 1.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(-4.0f, -12.0f, 3.0f, 8.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-4.0f, -5.0f, 3.0f, 8.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-0.5f, -8.5f, -2.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(BLADE, CubeListBuilder.create().texOffs(24, 25).addBox("blade_0", 0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 3.0f), PartPose.offset((float)-0.5f, (float)14.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void render(VacuumModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, int alpha) {
        int baseColor = FastColor.ARGB32.color((int)alpha, (int)0xFFFFFF);
        this.mainPart.render(matrixStack, builder, combinedLight, combinedOverlay, baseColor);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        float rotation = Mth.lerp((float)partialTicks, (float)module.oldRotation, (float)module.rotation);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -1.13f, 1.0f);
        matrixStack.scale(1.75f, 1.1f, 1.75f);
        for (int i = 0; i < 6; ++i) {
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(rotation * 2.0f + ((float)i + 0.5f) / 6.0f * 360.0f));
            matrixStack.translate(0.0, 0.0, 0.0625);
            this.blade.render(matrixStack, builder, combinedLight, combinedOverlay, baseColor);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_VACUUM_MODULE_UPGRADED : Textures.MODEL_VACUUM_MODULE;
    }
}

