/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import me.desht.pneumaticcraft.common.amadron.ImmutableBasket;
import me.desht.pneumaticcraft.common.amadron.MutableBasket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public abstract class ShoppingBasket
implements Iterable<ResourceLocation> {
    protected final Map<ResourceLocation, Integer> basket;

    public static ImmutableBasket empty() {
        return ImmutableBasket.EMPTY;
    }

    public static MutableBasket createMutable() {
        return new MutableBasket();
    }

    protected ShoppingBasket(Map<ResourceLocation, Integer> basket) {
        this.basket = basket;
    }

    public int getUnits(ResourceLocation offerId) {
        return this.basket.getOrDefault(offerId, 0);
    }

    @Override
    public Iterator<ResourceLocation> iterator() {
        return this.basket.keySet().iterator();
    }

    public void syncToPlayer(ServerPlayer player) {
        this.basket.forEach((? super K offerId, ? super V units) -> NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse((ResourceLocation)offerId, (int)units), player));
    }

    public boolean isEmpty() {
        return this.basket.values().stream().noneMatch(amount -> amount > 0);
    }

    public abstract ImmutableBasket toImmutable();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShoppingBasket that = (ShoppingBasket)o;
        return Objects.equals(this.basket, that.basket);
    }

    public int hashCode() {
        return Objects.hashCode(this.basket);
    }
}

