/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Optional;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.ElevatorFrameBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorCallerBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ElevatorCallerBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    public ElevatorCallerBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult brtr) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ElevatorCallerBlockEntity) {
            int floor;
            ElevatorCallerBlockEntity teEC = (ElevatorCallerBlockEntity)te;
            if (!level.isClientSide && (floor = this.getFloorForHit(teEC, brtr.getDirection(), brtr.getLocation().x, brtr.getLocation().y, brtr.getLocation().z)) >= 0) {
                ElevatorCallerBlock.setSurroundingElevators(level, pos, floor);
            }
        }
        return this.getRotation(state).getOpposite() == brtr.getDirection() ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private int getFloorForHit(ElevatorCallerBlockEntity teEC, Direction side, double hitX, double hitY, double hitZ) {
        double x;
        switch (side) {
            case NORTH: {
                x = 1.0 - Math.abs(hitX % 1.0);
                break;
            }
            case SOUTH: {
                x = Math.abs(hitX % 1.0);
                break;
            }
            case EAST: {
                x = 1.0 - Math.abs(hitZ % 1.0);
                break;
            }
            case WEST: {
                x = Math.abs(hitZ % 1.0);
                break;
            }
            default: {
                return -1;
            }
        }
        double y = hitY < 0.0 ? Math.abs(hitY % 1.0) : 1.0 - Math.abs(hitY % 1.0);
        for (ElevatorCallerBlockEntity.ElevatorButton button : teEC.getFloors()) {
            if (!(x >= (double)button.posX) || !(x <= (double)(button.posX + button.width)) || !(y >= (double)button.posY) || !(y <= (double)(button.posY + button.height))) continue;
            return button.floorNumber;
        }
        return -1;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.block();
    }

    public static void setSurroundingElevators(Level world, BlockPos pos, int floor) {
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            ElevatorCallerBlock.getElevatorBase(world, pos.relative(dir).relative(Direction.DOWN, 2)).ifPresent(te -> te.goToFloor(floor));
        }
    }

    public void onPlace(BlockState newState, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(newState, world, pos, oldState, isMoving);
        this.updateElevatorButtons(world, pos);
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        this.updateElevatorButtons(world, pos);
        super.onRemove(state, world, pos, newState, isMoving);
    }

    private void updateElevatorButtons(Level world, BlockPos pos) {
        Direction dir;
        boolean ok;
        Direction[] directionArray = DirectionUtil.HORIZONTALS;
        int n = directionArray.length;
        for (int i = 0; i < n && !(ok = ElevatorCallerBlock.getElevatorBase(world, pos.relative(dir = directionArray[i]).relative(Direction.DOWN, 2)).map(te -> {
            te.updateFloors(true);
            return true;
        }).orElse(false).booleanValue()); ++i) {
        }
    }

    private static Optional<ElevatorBaseBlockEntity> getElevatorBase(Level world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (block == ModBlocks.ELEVATOR_FRAME.get()) {
            return ElevatorFrameBlock.getElevatorBase((BlockGetter)world, pos);
        }
        if (block == ModBlocks.ELEVATOR_BASE.get()) {
            return world.getBlockEntity(pos, ModBlockEntityTypes.ELEVATOR_BASE.get()).filter(ElevatorBaseBlockEntity::isCoreElevator);
        }
        return Optional.empty();
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter pLevel, BlockPos pos, Direction side) {
        return pLevel.getBlockEntity(pos, ModBlockEntityTypes.ELEVATOR_CALLER.get()).map(teEc -> teEc.getEmittingRedstone() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ElevatorCallerBlockEntity(pPos, pState);
    }
}

