/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PressureChamberValveBlock
extends AbstractPneumaticCraftBlock
implements IBlockPressureChamber,
PneumaticCraftEntityBlock {
    public PressureChamberValveBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PNCBlockStateProperties.FORMED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity livingEntity, ItemStack iStack) {
        super.setPlacedBy(level, pos, state, livingEntity, iStack);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            if (PressureChamberValveBlockEntity.checkIfProperlyFormed(level, pos)) {
                ModCriterionTriggers.PRESSURE_CHAMBER.get().trigger(sp);
            }
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PNCBlockStateProperties.FORMED});
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (player.isShiftKeyDown()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return level.getBlockEntity(pos, ModBlockEntityTypes.PRESSURE_CHAMBER_VALVE.get()).map(te -> {
                if (te.multiBlockSize > 0) {
                    sp.openMenu((MenuProvider)te, pos);
                } else if (!te.accessoryValves.isEmpty()) {
                    for (PressureChamberValveBlockEntity valve : te.accessoryValves) {
                        if (valve.multiBlockSize <= 0) continue;
                        sp.openMenu((MenuProvider)valve, valve.getBlockPos());
                        break;
                    }
                } else {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                return ItemInteractionResult.CONSUME;
            }).orElse(ItemInteractionResult.FAIL);
        }
        return level.getBlockEntity(pos, ModBlockEntityTypes.PRESSURE_CHAMBER_VALVE.get()).filter(te -> te.multiBlockSize > 0).map(te -> ItemInteractionResult.SUCCESS).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            this.invalidateMultiBlock(world, pos);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    private void invalidateMultiBlock(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, PressureChamberValveBlockEntity.class).ifPresent(teValve -> {
                if (teValve.multiBlockSize > 0) {
                    teValve.onMultiBlockBreak();
                } else if (!teValve.accessoryValves.isEmpty()) {
                    teValve.accessoryValves.stream().filter(valve -> valve.multiBlockSize > 0).findFirst().ifPresent(PressureChamberValveBlockEntity::onMultiBlockBreak);
                }
            });
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PressureChamberValveBlockEntity(pPos, pState);
    }
}

