/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.block.ITubeNetworkConnector;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractNetworkedRedstoneModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class PressureTubeBlock
extends AbstractCamouflageBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock,
ITubeNetworkConnector {
    private static final int TUBE_WIDTH = 2;
    public static final int CORE_MIN = 6;
    public static final int CORE_MAX = 10;
    private static final double PLUG_SIZE = 2.5;
    private static final VoxelShape CORE_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] ARM_CONNECTED = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private static final VoxelShape[] ARM_CLOSED = new VoxelShape[]{Block.box((double)6.0, (double)3.5, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)12.5, (double)10.0), Block.box((double)6.0, (double)6.0, (double)3.5, (double)10.0, (double)10.0, (double)6.0), Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)12.5), Block.box((double)3.5, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)12.5, (double)10.0, (double)10.0)};
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap<Integer, VoxelShape>();
    private final BiFunction<BlockPos, BlockState, ? extends PressureTubeBlockEntity> blockEntityFactory;

    public PressureTubeBlock(BlockBehaviour.Properties props, BiFunction<BlockPos, BlockState, ? extends PressureTubeBlockEntity> blockEntityFactory) {
        super(props);
        this.blockEntityFactory = blockEntityFactory;
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return this.blockEntityFactory.apply(pPos, pState);
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            ModuleNetworkManager.getInstance(level).invalidateCache();
            AbstractNetworkedRedstoneModule.onNetworkReform(level, currentPos);
        }
        return stateIn;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        PressureTubeBlockEntity te = PressureTubeBlock.getPressureTube(reader, pos);
        return te != null ? this.getCachedShape(te) : CORE_SHAPE;
    }

    private VoxelShape getCachedShape(PressureTubeBlockEntity bePT) {
        int data = bePT.getShapeCacheKey();
        VoxelShape cachedShape = SHAPE_CACHE.get(data);
        if (cachedShape == null) {
            cachedShape = CORE_SHAPE;
            for (Direction dir : Direction.values()) {
                if (bePT.isSideClosed(dir)) {
                    cachedShape = Shapes.joinUnoptimized((VoxelShape)cachedShape, (VoxelShape)ARM_CLOSED[dir.get3DDataValue()], (BooleanOp)BooleanOp.OR);
                } else if (bePT.isSideConnected(dir)) {
                    cachedShape = Shapes.joinUnoptimized((VoxelShape)cachedShape, (VoxelShape)ARM_CONNECTED[dir.get3DDataValue()], (BooleanOp)BooleanOp.OR);
                }
                AbstractTubeModule module = bePT.getModule(dir);
                if (module == null) continue;
                cachedShape = Shapes.joinUnoptimized((VoxelShape)cachedShape, (VoxelShape)module.getShape(), (BooleanOp)BooleanOp.OR);
            }
            cachedShape = cachedShape.optimize();
            SHAPE_CACHE.put(data, cachedShape);
        }
        return cachedShape;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        AbstractTubeModule module;
        if (this.tryPlaceModule(player, world, pos, brtr.getDirection(), hand, false)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown() && (module = PressureTubeBlock.getFocusedModule(world, pos, player)) != null) {
            return module.onActivated(player, hand) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, brtr);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (!world.isClientSide() && tube != null) {
            tube.onNeighborTileUpdate(null);
        }
    }

    public boolean tryPlaceModule(Player player, Level world, BlockPos pos, Direction side, InteractionHand hand, boolean simulate) {
        AbstractTubeModule module;
        PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (tube == null) {
            return false;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        Item item = heldStack.getItem();
        if (item instanceof TubeModuleItem) {
            TubeModuleItem tubeModuleItem = (TubeModuleItem)item;
            module = tubeModuleItem.createModule(side, tube);
            if (tube.mayPlaceModule(module)) {
                if (simulate) {
                    module.markFake();
                }
                tube.setModule(side, module);
                if (!simulate && !world.isClientSide) {
                    this.neighborChanged(world.getBlockState(pos), world, pos, this, pos.relative(side), false);
                    world.updateNeighborsAt(pos, (Block)this);
                    if (!player.isCreative()) {
                        heldStack.shrink(1);
                    }
                    world.playSound(null, pos, SoundType.GLASS.getStepSound(), SoundSource.BLOCKS, SoundType.GLASS.getVolume() * 5.0f, SoundType.GLASS.getPitch() * 0.9f);
                    if (module instanceof INetworkedModule) {
                        ModuleNetworkManager.getInstance(world).invalidateCache();
                    }
                }
                if (!simulate) {
                    module.onPlaced();
                }
                return true;
            }
        } else if (heldStack.getItem() == ModItems.MODULE_EXPANSION_CARD.get() && !simulate && (module = PressureTubeBlock.getFocusedModule(world, pos, player)) != null && !module.isUpgraded() && module.canUpgrade()) {
            if (!world.isClientSide) {
                module.upgrade();
                tube.setChanged();
                tube.sendDescriptionPacket();
                if (!player.isCreative()) {
                    heldStack.shrink(1);
                }
            }
            return true;
        }
        return false;
    }

    public static AbstractTubeModule getFocusedModule(Level world, BlockPos pos, Player player) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockHitInfo rayTraceResult = PressureTubeBlock.doTrace((BlockGetter)world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = rayTraceResult.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE) {
            PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
            return tube == null ? null : tube.getModule(tubeHitInfo.dir);
        }
        return null;
    }

    @Nullable
    private static Direction getFocusedTubeSide(BlockGetter level, BlockPos pos, Player player) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockHitInfo blockHitInfo = PressureTubeBlock.doTrace(level, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = blockHitInfo.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return tubeHitInfo.dir == null ? Objects.requireNonNull(blockHitInfo.res()).getDirection() : tubeHitInfo.dir;
        }
        return null;
    }

    @Nullable
    private static PressureTubeBlockEntity getPressureTube(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        return te instanceof PressureTubeBlockEntity ? (PressureTubeBlockEntity)te : null;
    }

    @Nonnull
    private static BlockHitInfo doTrace(BlockGetter world, BlockPos pos, Vec3 origin, Vec3 direction) {
        PressureTubeBlockEntity tube;
        BlockHitResult bestRTR = null;
        TubeHitInfo hitInfo = TubeHitInfo.NO_HIT;
        BlockHitResult brtr = AABB.clip(List.of(CORE_SHAPE.bounds()), (Vec3)origin, (Vec3)direction, (BlockPos)pos);
        if (brtr != null) {
            hitInfo = TubeHitInfo.CENTER;
            bestRTR = brtr;
        }
        if ((tube = PressureTubeBlock.getPressureTube(world, pos)) == null) {
            return new BlockHitInfo(BlockHitResult.miss((Vec3)origin, (Direction)Direction.UP, (BlockPos)pos), TubeHitInfo.NO_HIT);
        }
        for (Direction dir : DirectionUtil.VALUES) {
            AABB arm = null;
            if (tube.isSideClosed(dir)) {
                arm = ARM_CLOSED[dir.get3DDataValue()].bounds();
            } else if (tube.isSideConnected(dir)) {
                arm = ARM_CONNECTED[dir.get3DDataValue()].bounds();
            }
            if (arm == null || (brtr = AABB.clip(List.of(arm), (Vec3)origin, (Vec3)direction, (BlockPos)pos)) == null || !PressureTubeBlock.isCloserIntersection(origin, (HitResult)bestRTR, (HitResult)brtr)) continue;
            hitInfo = new TubeHitInfo(dir, TubeHitInfo.PartType.TUBE);
            bestRTR = brtr;
        }
        for (Direction dir : DirectionUtil.VALUES) {
            AABB tubeAABB;
            AbstractTubeModule tm = tube.getModule(dir);
            if (tm == null || !PressureTubeBlock.isCloserIntersection(origin, (HitResult)bestRTR, (HitResult)(brtr = AABB.clip(List.of(tubeAABB = tm.getShape().bounds()), (Vec3)origin, (Vec3)direction, (BlockPos)pos))) && !tm.isInlineAndFocused(hitInfo)) continue;
            hitInfo = new TubeHitInfo(dir, TubeHitInfo.PartType.MODULE);
            bestRTR = brtr;
        }
        return new BlockHitInfo(bestRTR, hitInfo);
    }

    private static boolean isCloserIntersection(Vec3 origin, HitResult oldRTR, HitResult newRTR) {
        return newRTR != null && (oldRTR == null || origin.distanceToSqr(newRTR.getLocation()) <= origin.distanceToSqr(oldRTR.getLocation()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        AbstractTubeModule tm;
        PressureTubeBlockEntity tube;
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockHitInfo rayTraceResult = PressureTubeBlock.doTrace((BlockGetter)world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = rayTraceResult.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return super.getCloneItemStack(state, target, world, pos, player);
        }
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE && (tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos)) != null && (tm = tube.getModule(tubeHitInfo.dir)) != null) {
            return new ItemStack((ItemLike)tm.getItem());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player == null) {
            return false;
        }
        PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (tube == null) {
            return false;
        }
        AbstractTubeModule module = PressureTubeBlock.getFocusedModule(world, pos, player);
        if (player.isShiftKeyDown()) {
            if (module != null) {
                if (!player.isCreative()) {
                    for (ItemStack drop : module.getDrops()) {
                        ItemEntity entity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                        world.addFreshEntity((Entity)entity);
                        entity.playerTouch(player);
                    }
                }
                tube.setModule(module.getDirection(), null);
                this.neighborChanged(world.getBlockState(pos), world, pos, this, pos.relative(side), false);
                world.updateNeighborsAt(pos, (Block)this);
            } else {
                if (!player.isCreative()) {
                    PressureTubeBlock.dropResources((BlockState)world.getBlockState(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tube);
                }
                PressureTubeBlock.removeBlockSneakWrenched(world, pos);
            }
        } else if (module != null) {
            module.onActivated(player, hand);
        } else {
            Direction sideHit = PressureTubeBlock.getFocusedTubeSide((BlockGetter)world, pos, player);
            if (sideHit != null) {
                tube.setSideClosed(sideHit, !tube.isSideClosed(sideHit));
                if (tube.isSideClosed(sideHit)) {
                    PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos.relative(sideHit), PressureTubeBlockEntity.class).ifPresent(tube2 -> {
                        if (this.shouldCloseNeighbor((PressureTubeBlockEntity)tube2, sideHit)) {
                            tube2.setSideClosed(sideHit.getOpposite(), true);
                        }
                    });
                }
            }
        }
        return true;
    }

    private boolean shouldCloseNeighbor(PressureTubeBlockEntity tube2, Direction offset) {
        boolean doClose = false;
        for (Direction d : DirectionUtil.VALUES) {
            if (tube2.getConnectedNeighbor(d) == null) continue;
            if (d.getAxis() == offset.getAxis()) {
                doClose = true;
                continue;
            }
            return false;
        }
        return doClose;
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != state.getBlock()) {
            PressureTubeBlock.getModuleDrops(PressureTubeBlock.getPressureTube((BlockGetter)world, pos)).forEach(drop -> world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop)));
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    private static NonNullList<ItemStack> getModuleDrops(PressureTubeBlockEntity tube) {
        NonNullList drops = NonNullList.create();
        if (tube != null) {
            tube.tubeModules().map(AbstractTubeModule::getDrops).forEach(arg_0 -> drops.addAll(arg_0));
        }
        return drops;
    }

    public int getSignal(BlockState state, BlockGetter par1IBlockAccess, BlockPos pos, Direction side) {
        PressureTubeBlockEntity tePt = PressureTubeBlock.getPressureTube(par1IBlockAccess, pos);
        if (tePt != null) {
            int redstoneLevel = 0;
            for (Direction face : DirectionUtil.VALUES) {
                AbstractTubeModule tm = tePt.getModule(face);
                if (tm == null || side.getOpposite() != face && (face == side || !tm.isInline())) continue;
                redstoneLevel = Math.max(redstoneLevel, tm.getRedstoneLevel());
            }
            return redstoneLevel;
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Override
    public boolean canConnectToNetwork(Level level, BlockPos pos, Direction dir, BlockState state) {
        PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)level, pos);
        return tube != null && tube.isSideConnected(dir);
    }

    private record BlockHitInfo(BlockHitResult res, @Nonnull TubeHitInfo tubeHitInfo) {
    }

    public record TubeHitInfo(Direction dir, PartType type) {
        static final TubeHitInfo NO_HIT = new TubeHitInfo(null, null);
        public static final TubeHitInfo CENTER = new TubeHitInfo(null, PartType.TUBE);

        static enum PartType {
            TUBE,
            MODULE;

        }
    }
}

