/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.hopper;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.block.entity.hopper.AbstractHopperBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.LiquidHopperMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class LiquidHopperBlockEntity
extends AbstractHopperBlockEntity<LiquidHopperBlockEntity>
implements ISerializableTanks {
    private int comparatorValue = -1;
    @DescSynced
    @GuiSynced
    private final HopperTank tank = new HopperTank(16000);
    private final WrappedFluidTank inputWrapper = new WrappedFluidTank(this.tank, true);
    private final WrappedFluidTank outputWrapper = new WrappedFluidTank(this.tank, false);
    @GuiSynced
    private final RedstoneController<LiquidHopperBlockEntity> rsController = new RedstoneController<LiquidHopperBlockEntity>(this);
    private final Lazy<BlockCapabilityCache<IFluidHandler, Direction>> inputCache = Lazy.of(() -> this.createFluidHandlerCache(this.inputDir));
    private final Lazy<BlockCapabilityCache<IFluidHandler, Direction>> outputCache = Lazy.of(() -> this.createFluidHandlerCache(this.getRotation()));

    public LiquidHopperBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.LIQUID_HOPPER.get(), pos, state);
    }

    private BlockCapabilityCache<IFluidHandler, Direction> getInputCache() {
        return (BlockCapabilityCache)this.inputCache.get();
    }

    private BlockCapabilityCache<IFluidHandler, Direction> getOutputCache() {
        return (BlockCapabilityCache)this.outputCache.get();
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@javax.annotation.Nullable Direction dir) {
        if (dir == this.inputDir) {
            return this.inputWrapper;
        }
        if (dir == this.getRotation()) {
            return this.outputWrapper;
        }
        return this.tank;
    }

    @Override
    protected int getComparatorValueInternal() {
        if (this.comparatorValue < 0) {
            if (this.tank.getFluidAmount() == 0) {
                return 0;
            }
            FluidStack fluidStack = this.tank.getFluid();
            this.comparatorValue = (int)(1.0f + (float)fluidStack.getAmount() / (float)this.tank.getCapacity() * 14.0f);
        }
        return this.comparatorValue;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickServer() {
        FluidStack fluidStack;
        super.tickServer();
        if (this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0 && !(fluidStack = this.tank.getFluid()).isEmpty() && fluidStack.getAmount() < 16000) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), 16000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    protected boolean doExport(int maxItems) {
        if (this.tank.getFluid().isEmpty()) {
            return false;
        }
        Direction dir = this.getRotation();
        IFluidHandler dstHandler = (IFluidHandler)this.getOutputCache().getCapability();
        if (dstHandler != null) {
            int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
            FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)dstHandler, (IFluidHandler)this.tank, (int)amount, (boolean)true);
            return !transferred.isEmpty();
        }
        if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0) {
            for (Entity e : this.cachedOutputEntities) {
                FluidStack transferred;
                if (!e.isAlive() || (transferred = IOHelper.getFluidHandlerForEntity(e, this.getRotation().getOpposite()).map(h -> {
                    int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
                    return FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                }).orElse(FluidStack.EMPTY)).isEmpty()) continue;
                return true;
            }
        }
        for (Entity e : this.cachedOutputEntities) {
            if (!e.isAlive() || !(e instanceof ItemEntity)) continue;
            ItemEntity entity = (ItemEntity)e;
            int maxFill = entity.getItem().getItem() instanceof BucketItem ? 1000 : maxItems * 100;
            FluidActionResult res = FluidUtil.tryFillContainer((ItemStack)entity.getItem(), (IFluidHandler)this.tank, (int)maxFill, null, (boolean)true);
            if (res.success) {
                entity.setItem(res.result);
            }
            if (!this.tank.isEmpty()) continue;
            break;
        }
        if (((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue() && this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0 && this.tank.getFluidAmount() >= this.leaveMaterialCount + 1000) {
            return FluidUtils.tryPourOutFluid(this.outputWrapper, this.nonNullLevel(), this.getBlockPos().relative(dir), false, false, IFluidHandler.FluidAction.EXECUTE);
        }
        return false;
    }

    @Override
    protected boolean doImport(int maxItems) {
        IFluidHandler srcHandler = (IFluidHandler)this.getInputCache().getCapability();
        if (srcHandler != null) {
            int filledFluid;
            FluidStack fluid = srcHandler.drain(maxItems * 100, IFluidHandler.FluidAction.SIMULATE);
            if (!fluid.isEmpty() && (filledFluid = this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                srcHandler.drain(filledFluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            return false;
        }
        if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0) {
            for (Entity e : this.cachedInputEntities) {
                FluidStack transferred;
                if (!e.isAlive() || (transferred = IOHelper.getFluidHandlerForEntity(e, this.inputDir.getOpposite()).map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)h, (int)(maxItems * 100), (boolean)true)).orElse(FluidStack.EMPTY)).isEmpty()) continue;
                return true;
            }
        }
        for (Entity e : this.cachedInputEntities) {
            if (!e.isAlive() || !(e instanceof ItemEntity)) continue;
            ItemEntity entity = (ItemEntity)e;
            int max = entity.getItem().getItem() instanceof BucketItem ? 1000 : maxItems * 100;
            FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)entity.getItem(), (IFluidHandler)this.tank, (int)max, null, (boolean)true);
            if (res.success) {
                entity.setItem(res.result);
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) continue;
            break;
        }
        if (((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue() && this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
            BlockPos neighborPos = this.getBlockPos().relative(this.inputDir);
            return !FluidUtils.tryPickupFluid(this.inputWrapper, this.nonNullLevel(), neighborPos, false, IFluidHandler.FluidAction.EXECUTE).isEmpty();
        }
        return false;
    }

    @Override
    protected void setupInputOutputRegions() {
        this.inputAABB = new AABB(this.worldPosition.relative(this.inputDir));
        this.outputAABB = new AABB(this.getBlockPos().relative(this.getRotation()));
        this.inputCache.invalidate();
        this.outputCache.invalidate();
        this.cachedInputEntities.clear();
        this.cachedOutputEntities.clear();
    }

    @Override
    boolean shouldScanForEntities(Direction dir) {
        BlockEntity te = this.getCachedNeighbor(dir);
        return (te == null || IOHelper.getFluidHandlerForBlock(te, dir.getOpposite()).isEmpty()) && !this.isInputBlocked();
    }

    public HopperTank getTank() {
        return this.tank;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.comparatorValue = -1;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.tank);
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new LiquidHopperMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public RedstoneController<LiquidHopperBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    public class HopperTank
    extends SmartSyncTank {
        HopperTank(int capacity) {
            super(LiquidHopperBlockEntity.this, capacity);
        }

        @Override
        protected void onContentsChanged(FluidStack prevStack) {
            LiquidHopperBlockEntity.this.comparatorValue = -1;
            super.onContentsChanged(prevStack);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            int filled = super.fill(resource, doFill);
            if (LiquidHopperBlockEntity.this.isCreative && this.getFluidAmount() > 0 && this.getFluid().getFluid() == resource.getFluid()) {
                return resource.getAmount();
            }
            return filled;
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return super.drain(resource, LiquidHopperBlockEntity.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return super.drain(maxDrain, LiquidHopperBlockEntity.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }
    }

    class WrappedFluidTank
    implements IFluidTank,
    IFluidHandler {
        private final IFluidTank wrappedTank;
        private final boolean inbound;

        WrappedFluidTank(IFluidTank wrappedTank, boolean inbound) {
            this.wrappedTank = wrappedTank;
            this.inbound = inbound;
        }

        public FluidStack getFluid() {
            return this.wrappedTank.getFluid();
        }

        public int getFluidAmount() {
            return this.wrappedTank.getFluidAmount();
        }

        public int getCapacity() {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return this.inbound ? this.wrappedTank.fill(resource, doFill) : 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : LiquidHopperBlockEntity.this.tank.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : this.wrappedTank.drain(maxDrain, doDrain);
        }
    }
}

