/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.tube;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class PressureTubeBlockEntity
extends AbstractAirHandlingBlockEntity
implements IAirListener,
IManoMeasurable,
CamouflageableBlockEntity {
    public static final ModelProperty<Short> CONNECTION_PROPERTY = new ModelProperty();
    @DescSynced
    private int sidesClosed;
    @DescSynced
    private int sidesVisuallyConnected;
    @DescSynced
    private Direction inLineModuleDir = null;
    private int sidesActuallyConnected;
    private final EnumMap<Direction, AbstractTubeModule> modules = new EnumMap(Direction.class);
    private BlockState camoState;
    private AABB renderBoundingBox = null;
    private Integer shapeCacheKey = null;

    public PressureTubeBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.PRESSURE_TUBE.get(), pos, state, PressureTier.TIER_ONE, 1000);
    }

    PressureTubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volumePressureTube) {
        super(type, pos, state, tier, volumePressureTube, 0);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.sidesClosed = tag.getInt("sidesClosed");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.sidesClosed != 0) {
            tag.putInt("sidesClosed", this.sidesClosed);
        }
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        this.writeModulesToNBT(tag);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    public void writeModulesToNBT(CompoundTag tag) {
        ListTag moduleList = new ListTag();
        for (Direction d : DirectionUtil.VALUES) {
            AbstractTubeModule tm = this.getModule(d);
            if (tm == null) continue;
            CompoundTag moduleTag = new CompoundTag();
            moduleTag.putString("type", tm.getType().toString());
            tm.writeToNBT(moduleTag);
            moduleList.add((Object)moduleTag);
        }
        if (!moduleList.isEmpty()) {
            tag.put("modules", (Tag)moduleList);
        }
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        EnumSet<Direction> dirs = EnumSet.allOf(Direction.class);
        ListTag moduleList = tag.getList("modules", 10);
        for (int i = 0; i < moduleList.size(); ++i) {
            CompoundTag moduleTag = moduleList.getCompound(i);
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)moduleTag.getString("type")));
            Direction dir = Direction.from3DDataValue((int)moduleTag.getInt("dir"));
            if (item instanceof TubeModuleItem) {
                AbstractTubeModule module = ((TubeModuleItem)item).createModule(dir, this);
                module.readFromNBT(moduleTag);
                AbstractTubeModule oldModule = this.getModule(module.getDirection());
                if (oldModule != null && !oldModule.getType().equals((Object)module.getType())) {
                    oldModule.onRemoved();
                }
                this.setModule(module.getDirection(), module);
                dirs.remove(module.getDirection());
                continue;
            }
            Log.error("unknown tube module type: " + moduleTag.getString("type"), new Object[0]);
        }
        for (Direction d : dirs) {
            AbstractTubeModule module = this.getModule(d);
            if (module == null) continue;
            this.setModule(d, null);
        }
        this.updateRenderBoundingBox();
        if (this.hasLevel() && this.nonNullLevel().isClientSide) {
            this.forceBlockEntityRerender();
        }
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.requestModelDataUpdate();
        this.purgeShapeCacheKey();
    }

    private void updateRenderBoundingBox() {
        this.renderBoundingBox = new AABB(this.getBlockPos());
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.modules.containsKey(dir) || this.modules.get(dir).getRenderBoundingBox() == null) continue;
            this.renderBoundingBox = this.renderBoundingBox.minmax(this.modules.get(dir).getRenderBoundingBox());
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        for (Direction dir : DirectionUtil.VALUES) {
            AbstractTubeModule tm = this.getModule(dir);
            if (tm == null) continue;
            tm.tickClient();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        boolean couldLeak = true;
        for (Direction dir : DirectionUtil.VALUES) {
            AbstractTubeModule tm = this.getModule(dir);
            if (tm != null) {
                couldLeak = false;
                tm.tickServer();
            }
            if (!this.isSideClosed(dir)) continue;
            couldLeak = false;
        }
        Direction leakDir = couldLeak ? this.getLeakDir() : null;
        this.airHandler.setSideLeaking((Direction)(this.canConnectPneumatic(leakDir) ? leakDir : null));
    }

    private Direction getLeakDir() {
        return switch (this.sidesActuallyConnected) {
            case 1 -> Direction.UP;
            case 2 -> Direction.DOWN;
            case 4 -> Direction.SOUTH;
            case 8 -> Direction.NORTH;
            case 16 -> Direction.EAST;
            case 32 -> Direction.WEST;
            default -> null;
        };
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.nonNullLevel().isClientSide) {
            this.discoverConnectedNeighbors();
        }
        this.tubeModules().forEach(AbstractTubeModule::onPlaced);
        this.purgeShapeCacheKey();
    }

    @Override
    public void onAirDispersion(IAirHandlerMachine handler, @Nullable Direction side, int airDispersed) {
        AbstractTubeModule abstractTubeModule;
        if (side != null && (abstractTubeModule = this.getModule(side)) instanceof IInfluenceDispersing) {
            IInfluenceDispersing dispersing = (IInfluenceDispersing)((Object)abstractTubeModule);
            dispersing.onAirDispersion(airDispersed);
        }
    }

    @Override
    public int getMaxDispersion(IAirHandlerMachine handler, @Nullable Direction side) {
        int n;
        AbstractTubeModule abstractTubeModule;
        if (side != null && (abstractTubeModule = this.getModule(side)) instanceof IInfluenceDispersing) {
            IInfluenceDispersing dispersing = (IInfluenceDispersing)((Object)abstractTubeModule);
            n = dispersing.getMaxDispersion();
        } else {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public AbstractTubeModule getModule(Direction side) {
        return this.modules.get(side);
    }

    public boolean isSideClosed(Direction dir) {
        return DirectionUtil.getDirectionBit(this.sidesClosed, dir);
    }

    public void setSideClosed(Direction dir, boolean closed) {
        byte b = DirectionUtil.setDirectionBit(this.sidesClosed, dir, closed);
        if (b != this.sidesClosed) {
            this.sidesClosed = b;
            this.initializeHullAirHandlers();
            this.discoverConnectedNeighbors();
            this.setChanged();
            this.level.blockUpdated(this.getBlockPos(), this.getBlockState().getBlock());
            this.purgeShapeCacheKey();
        }
    }

    public boolean isSideConnected(Direction dir) {
        return DirectionUtil.getDirectionBit(this.sidesVisuallyConnected, dir);
    }

    public void setSideConnected(Direction dir, boolean connected) {
        this.sidesActuallyConnected = DirectionUtil.setDirectionBit(this.sidesActuallyConnected, dir, connected);
        this.sidesVisuallyConnected = this.calculateVisuallyConnected();
    }

    public Stream<AbstractTubeModule> tubeModules() {
        return this.modules.values().stream().filter(Objects::nonNull);
    }

    public boolean mayPlaceModule(AbstractTubeModule module) {
        Direction side = module.getDirection();
        return this.inLineModuleDir == null && this.getModule(side) == null && !this.isSideClosed(side) && (!module.isInline() || this.getConnectedNeighbor(side) == null);
    }

    public void setModule(Direction side, AbstractTubeModule module) {
        if (module != null) {
            if (module.isInline()) {
                this.inLineModuleDir = side;
            }
        } else {
            if (this.inLineModuleDir == side) {
                this.inLineModuleDir = null;
            }
            if (this.modules.containsKey(side)) {
                this.modules.get(side).onRemoved();
            }
        }
        if (module != null) {
            this.modules.put(side, module);
        } else {
            this.modules.remove(side);
        }
        if (this.getLevel() != null && !this.getLevel().isClientSide) {
            this.discoverConnectedNeighbors();
            this.sendDescriptionPacket();
            this.setChanged();
            this.purgeShapeCacheKey();
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return !(side == null || this.inLineModuleDir != null && this.inLineModuleDir.getAxis() != side.getAxis() || this.isSideClosed(side) || this.getModule(side) != null && !this.getModule(side).isInline());
    }

    @Override
    public void onNeighborTileUpdate(BlockPos tilePos) {
        super.onNeighborTileUpdate(tilePos);
        this.tubeModules().filter(module -> this.getBlockPos().relative(module.getDirection()).equals((Object)tilePos)).forEach(AbstractTubeModule::onNeighborTileUpdate);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.tubeModules().forEach(AbstractTubeModule::onNeighborBlockUpdate);
        this.discoverConnectedNeighbors();
    }

    private void discoverConnectedNeighbors() {
        int prevSidesConnected = this.sidesActuallyConnected;
        ArrayList neighbourDirections = new ArrayList();
        this.airHandler.getConnectedAirHandlers(this).forEach(connection -> neighbourDirections.add(connection.getDirection()));
        this.sidesVisuallyConnected = 0;
        this.sidesActuallyConnected = 0;
        neighbourDirections.forEach(d -> this.setSideConnected((Direction)d, true));
        this.sidesVisuallyConnected = this.calculateVisuallyConnected();
        if (this.sidesActuallyConnected != prevSidesConnected) {
            this.purgeShapeCacheKey();
        }
    }

    private int calculateVisuallyConnected() {
        if (this.sidesClosed != 0 || !this.modules.isEmpty()) {
            return this.sidesActuallyConnected;
        }
        return switch (this.sidesActuallyConnected) {
            case 1, 2 -> 3;
            case 4, 8 -> 12;
            case 16, 32 -> 48;
            default -> this.sidesActuallyConnected;
        };
    }

    public BlockEntity getConnectedNeighbor(Direction dir) {
        BlockEntity te;
        AbstractTubeModule tm = this.getModule(dir);
        if (!this.isSideClosed(dir) && (tm == null || tm.isInline() && dir.getAxis() == tm.getDirection().getAxis()) && (te = this.getCachedNeighbor(dir)) != null && PNCCapabilities.getAirHandler(te, dir.getOpposite()).isPresent()) {
            return te;
        }
        return null;
    }

    public AABB getRenderBoundingBox() {
        return this.renderBoundingBox != null ? this.renderBoundingBox : new AABB(this.getBlockPos());
    }

    @Override
    public void printManometerMessage(Player player, List<Component> text) {
        BlockHitResult blockHitResult;
        AbstractTubeModule tm;
        HitResult hitResult = RayTraceUtils.getEntityLookedObject((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        if (hitResult instanceof BlockHitResult && (tm = this.getModule((blockHitResult = (BlockHitResult)hitResult).getDirection())) != null) {
            tm.addInfo(text);
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.onCamouflageChanged(this);
    }

    @Override
    protected ModelData.Builder modelDataBuilder() {
        return super.modelDataBuilder().with(CONNECTION_PROPERTY, (Object)((short)(this.sidesClosed | this.sidesVisuallyConnected << 8)));
    }

    public int getShapeCacheKey() {
        if (this.shapeCacheKey == null) {
            int[] vals = new int[8];
            vals[0] = this.sidesVisuallyConnected;
            vals[1] = this.sidesClosed;
            for (Direction d : DirectionUtil.VALUES) {
                AbstractTubeModule m = this.getModule(d);
                vals[d.get3DDataValue() + 2] = m == null ? 0 : m.getInternalId();
            }
            this.shapeCacheKey = Arrays.hashCode(vals);
        }
        return this.shapeCacheKey;
    }

    private void purgeShapeCacheKey() {
        this.shapeCacheKey = null;
    }
}

