/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.KeroseneLampLightBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.KeroseneLampMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class KeroseneLampBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<KeroseneLampBlockEntity>,
ISerializableTanks,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<KeroseneLampBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("standard.always", new ItemStack((ItemLike)Items.GUNPOWDER), te -> true), new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.REDSTONE), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("standard.low_signal", new ItemStack((ItemLike)Items.REDSTONE_TORCH), te -> te.getCurrentRedstonePower() == 0), new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("keroseneLamp.interpolate", new ItemStack((ItemLike)Items.COMPARATOR), te -> te.getCurrentRedstonePower() > 0));
    public static final int INVENTORY_SIZE = 2;
    public static final int TICK_RATE = 5;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int RS_MODE_INTERPOLATE = 3;
    private static final int LIGHT_SPACING = 3;
    public static final int MAX_RANGE = 30;
    private final Set<BlockPos> managingLights = new HashSet<BlockPos>();
    private boolean isOn;
    @GuiSynced
    private int range;
    @GuiSynced
    private int targetRange = 10;
    @GuiSynced
    private final RedstoneController<KeroseneLampBlockEntity> rsController = new RedstoneController<KeroseneLampBlockEntity>(this, REDSTONE_MODES);
    @GuiSynced
    private float fuel;
    private int checkingX;
    private int checkingY;
    private int checkingZ;
    private int rangeSq;
    @DescSynced
    @GuiSynced
    private final SmartSyncTank tank = new SmartSyncTank(this, 2000){

        @Override
        protected void onContentsChanged(FluidStack prevStack) {
            super.onContentsChanged(prevStack);
            if (prevStack.getFluid() != this.fluidStack.getFluid()) {
                KeroseneLampBlockEntity.this.fuelQuality = KeroseneLampBlockEntity.this.calculateFuelQuality(this.fluidStack.getFluid());
            }
        }
    };
    @DescSynced
    private float fuelQuality = -1.0f;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };
    private static final Codec<List<BlockPos>> BLOCKPOS_LIST_CODEC = BlockPos.CODEC.listOf();

    public KeroseneLampBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.KEROSENE_LAMP.get(), pos, state);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        Level level = this.nonNullLevel();
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue() && level.random.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)this.getBlockPos().getX() + 0.4 + 0.2 * level.random.nextDouble(), (double)this.getBlockPos().getY() + 0.2 + (double)this.tank.getFluidAmount() / 1000.0 * 3.0 / 16.0, (double)this.getBlockPos().getZ() + 0.4 + 0.2 * level.random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.fuelQuality < 0.0f) {
            this.fuelQuality = this.calculateFuelQuality(this.tank.getFluid().getFluid());
        }
        this.processFluidItem(0, 1);
        if (this.nonNullLevel().getGameTime() % 5L == 0L) {
            int effectiveRange;
            int n = effectiveRange = this.rsController.shouldRun() && this.fuel > 0.0f ? this.targetRange : 0;
            if (this.rsController.getCurrentMode() == 3) {
                effectiveRange = (int)((double)this.rsController.getCurrentRedstonePower() / 15.0 * (double)this.targetRange);
            }
            this.updateRange(Math.min(effectiveRange, this.tank.getFluidAmount()));
            this.updateLights();
            this.useFuel();
        }
    }

    public float calculateFuelQuality(Fluid fuel) {
        float quality;
        boolean isKerosene = fuel.is(PneumaticCraftTags.Fluids.KEROSENE);
        float f = (Boolean)ConfigHelper.common().machines.keroseneLampCanUseAnyFuel.get() != false ? (float)PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(this.level, fuel) / 110.0f : (quality = isKerosene ? 10000.0f : 0.0f);
        if (isKerosene) {
            quality *= 2.5f;
        }
        quality = (float)((double)quality * (Double)ConfigHelper.common().machines.keroseneLampFuelEfficiency.get());
        return quality;
    }

    private void useFuel() {
        if (this.fuelQuality == 0.0f) {
            return;
        }
        this.fuel -= (float)this.rangeSq * 3.0f;
        while (this.fuel <= 0.0f && !this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
            this.fuel += this.fuelQuality;
        }
        if (this.fuel < 0.0f) {
            this.fuel = 0.0f;
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.checkingX = this.getBlockPos().getX();
        this.checkingY = this.getBlockPos().getY();
        this.checkingZ = this.getBlockPos().getZ();
    }

    public void removeLights() {
        for (BlockPos pos : this.managingLights) {
            if (!this.nonNullLevel().isLoaded(pos) || !this.isLampLight(pos)) continue;
            this.nonNullLevel().removeBlock(pos, false);
        }
    }

    private boolean isLampLight(BlockPos pos) {
        return this.nonNullLevel().getBlockState(pos).getBlock() == ModBlocks.KEROSENE_LAMP_LIGHT.get();
    }

    private void updateLights() {
        int roundedRange = this.range / 3 * 3;
        this.checkingX += 3;
        if (this.checkingX > this.getBlockPos().getX() + roundedRange) {
            this.checkingX = this.getBlockPos().getX() - roundedRange;
            this.checkingY += 3;
            if (this.checkingY > this.getBlockPos().getY() + roundedRange) {
                this.checkingY = this.getBlockPos().getY() - roundedRange;
                this.checkingZ += 3;
                if (this.checkingZ > this.getBlockPos().getZ() + roundedRange) {
                    this.checkingZ = this.getBlockPos().getZ() - roundedRange;
                }
            }
        }
        BlockPos pos = new BlockPos(this.checkingX, this.checkingY, this.checkingZ);
        if (!this.nonNullLevel().isLoaded(pos)) {
            return;
        }
        if (this.managingLights.contains(pos)) {
            if (this.isLampLight(pos)) {
                if (!this.passesRaytraceTest(pos, this.getBlockPos())) {
                    this.nonNullLevel().removeBlock(pos, false);
                    this.managingLights.remove(pos);
                }
            } else {
                this.managingLights.remove(pos);
            }
        } else {
            this.tryAddLight(pos);
        }
    }

    private void updateRange(int targetRange) {
        if (targetRange > this.range) {
            ++this.range;
            int roundedRange = this.range / 3 * 3;
            for (int x = -roundedRange; x <= roundedRange; x += 3) {
                for (int y = -roundedRange; y <= roundedRange; y += 3) {
                    for (int z = -roundedRange; z <= roundedRange; z += 3) {
                        BlockPos pos = this.getBlockPos().offset(x, y, z);
                        if (this.managingLights.contains(pos)) continue;
                        this.tryAddLight(pos);
                    }
                }
            }
        } else if (targetRange < this.range) {
            --this.range;
            Iterator<BlockPos> iterator = this.managingLights.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                if (!this.nonNullLevel().isLoaded(pos)) continue;
                if (!this.isLampLight(pos)) {
                    iterator.remove();
                    continue;
                }
                if (!(PneumaticCraftUtils.distBetweenSq(pos, this.getBlockPos()) > (double)this.rangeSq)) continue;
                this.nonNullLevel().removeBlock(pos, false);
                iterator.remove();
            }
        }
        this.rangeSq = this.range * this.range;
        boolean wasOn = this.isOn;
        boolean bl = this.isOn = this.range > 0;
        if (this.isOn != wasOn) {
            this.nonNullLevel().getChunkSource().getLightEngine().checkBlock(this.getBlockPos());
            this.nonNullLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.isOn)));
        }
    }

    private boolean passesRaytraceTest(BlockPos pos, BlockPos lampPos) {
        ClipContext ctx = new ClipContext(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), new Vec3((double)lampPos.getX() + 0.5, (double)lampPos.getY() + 0.5, (double)lampPos.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.getLevel())));
        BlockHitResult rtr = this.nonNullLevel().clip(ctx);
        return rtr.getType() == HitResult.Type.BLOCK && rtr.getBlockPos().equals((Object)lampPos);
    }

    private void tryAddLight(BlockPos pos) {
        if (!((Boolean)ConfigHelper.common().advanced.disableKeroseneLampFakeAirBlock.get()).booleanValue() && this.nonNullLevel().isLoaded(pos) && PneumaticCraftUtils.distBetweenSq(pos, this.getBlockPos()) <= (double)this.rangeSq && this.nonNullLevel().isEmptyBlock(pos) && !this.isLampLight(pos) && this.passesRaytraceTest(pos, this.getBlockPos())) {
            this.nonNullLevel().setBlockAndUpdate(pos, ((KeroseneLampLightBlock)((Object)ModBlocks.KEROSENE_LAMP_LIGHT.get())).defaultBlockState());
            this.managingLights.add(pos);
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onDescUpdate() {
        this.nonNullLevel().getChunkSource().getLightEngine().checkBlock(this.getBlockPos());
        super.onDescUpdate();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        BLOCKPOS_LIST_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), List.copyOf(this.managingLights)).result().ifPresent(t -> tag.put("lights", t));
        tag.putByte("targetRange", (byte)this.targetRange);
        tag.putByte("range", (byte)this.range);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.managingLights.clear();
        BLOCKPOS_LIST_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("lights")).result().ifPresent(this.managingLights::addAll);
        this.fuelQuality = this.calculateFuelQuality(this.tank.getFluid().getFluid());
        this.targetRange = tag.getByte("targetRange");
        this.range = tag.getByte("range");
        this.rangeSq = this.range * this.range;
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public RedstoneController<KeroseneLampBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.targetRange = Mth.clamp((int)Integer.parseInt(tag), (int)1, (int)30);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public IFluidHandler getFluidHandler(@javax.annotation.Nullable Direction dir) {
        return this.tank;
    }

    public SmartSyncTank getTank() {
        return this.tank;
    }

    public int getRange() {
        return this.range;
    }

    public int getTargetRange() {
        return this.targetRange;
    }

    public float getFuel() {
        return this.fuel;
    }

    public float getFuelQuality() {
        return this.fuelQuality;
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.tank);
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new KeroseneLampMenu(i, playerInventory, this.getBlockPos());
    }
}

