/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;

public class DroneAINearestAttackableTarget
extends TargetGoal {
    private final DroneEntity drone;
    private final ProgWidget widget;
    private final DistanceSorter distanceSorter;
    private LivingEntity targetEntity;

    public DroneAINearestAttackableTarget(DroneEntity drone, boolean mustSee, ProgWidget widget) {
        super((Mob)drone, mustSee, false);
        this.drone = drone;
        this.widget = widget;
        this.distanceSorter = new DistanceSorter((Entity)drone);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        IMaxActions m;
        if (this.drone.hasMinigun() && this.drone.getSlotForAmmo() < 0) {
            return false;
        }
        ProgWidget progWidget = this.widget;
        if (progWidget instanceof IMaxActions && (m = (IMaxActions)((Object)progWidget)).useMaxActions() && this.drone.getAttackCount() >= m.getMaxActions()) {
            return false;
        }
        progWidget = this.widget;
        if (!(progWidget instanceof IEntityProvider)) {
            return false;
        }
        IEntityProvider provider = (IEntityProvider)((Object)progWidget);
        List<Entity> list = provider.getValidEntities(this.drone.level());
        list.sort(this.distanceSorter);
        for (Entity entity : list) {
            if (!entity.isAlive() || entity == this.mob || !(entity instanceof LivingEntity) || this.shouldIgnore(entity)) continue;
            this.targetEntity = (LivingEntity)entity;
            return true;
        }
        return false;
    }

    private boolean shouldIgnore(Entity entity) {
        return entity.isSpectator() || entity instanceof Player && ((Player)entity).isCreative() || this.mustSee && !this.mob.getSensing().hasLineOfSight(entity);
    }

    public void start() {
        this.mob.setTarget(this.targetEntity);
        super.start();
    }

    private record DistanceSorter(Entity entity) implements Comparator<Entity>
    {
        @Override
        public int compare(Entity e1, Entity e2) {
            return Double.compare(this.entity.distanceToSqr(e1), this.entity.distanceToSqr(e2));
        }
    }
}

