/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.DroneClaimManager;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class DroneGoToChargingStation
extends Goal {
    private final DroneEntity drone;
    public boolean isExecuting;
    private ChargingStationBlockEntity curCharger;
    private int chargingTime;

    public DroneGoToChargingStation(DroneEntity drone) {
        this.drone = drone;
        this.setFlags(EnumSet.allOf(Goal.Flag.class));
    }

    public boolean canUse() {
        ArrayList<ChargingStationBlockEntity> validChargingStations = new ArrayList<ChargingStationBlockEntity>();
        BasicAirHandler handler = this.drone.getAirHandler();
        if (handler.getPressure() < 1.0f && handler.getPressure() > 0.001f) {
            int maxDistSq = (Integer)ConfigHelper.common().drones.maxDroneChargingStationSearchRange.get() * (Integer)ConfigHelper.common().drones.maxDroneChargingStationSearchRange.get();
            for (ChargingStationBlockEntity station : GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.drone.level()).getChargingStations()) {
                Level level = this.drone.level();
                BlockPos chargingPos = station.getBlockPos();
                if (station.getLevel() != level || !level.isLoaded(chargingPos) || !(this.drone.distanceToSqr(Vec3.atCenterOf((Vec3i)chargingPos)) <= (double)maxDistSq)) continue;
                if (DroneClaimManager.getInstance(this.drone.level()).isClaimed(chargingPos)) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.claimed", chargingPos);
                    continue;
                }
                if (station.getPressure() <= 1.0f) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.notEnoughPressure", chargingPos);
                    continue;
                }
                if (station.getUpgrades(ModUpgrades.DISPENSER.get()) == 0) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.noDispenserUpgrades", chargingPos);
                    continue;
                }
                validChargingStations.add(station);
            }
        }
        validChargingStations.sort(Comparator.comparingDouble(te -> te.getBlockPos().distSqr((Vec3i)this.drone.blockPosition())));
        for (ChargingStationBlockEntity station : validChargingStations) {
            if (SecurityStationBlockEntity.isProtectedFromPlayer((Player)this.drone.getFakePlayer(), station.getBlockPos(), false)) {
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.protected", station.getBlockPos());
                continue;
            }
            if (this.drone.getPathNavigator().moveToXYZ((double)station.getBlockPos().getX() + 0.5, station.getBlockPos().getY() + 1, (double)station.getBlockPos().getZ() + 0.5) || this.drone.getPathNavigator().isGoingToTeleport()) {
                this.isExecuting = true;
                this.curCharger = station;
                DroneClaimManager.getInstance(this.drone.level()).claim(station.getBlockPos());
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.chargingStation.debug.cantNavigate", station.getBlockPos());
        }
        this.isExecuting = false;
        return false;
    }

    public boolean canContinueToUse() {
        if (this.curCharger.getUpgrades(ModUpgrades.DISPENSER.get()) == 0 || this.curCharger.isRemoved()) {
            this.isExecuting = false;
            return false;
        }
        if (!this.drone.getPathNavigator().isGoingToTeleport() && (this.drone.getNavigation().getPath() == null || this.drone.getNavigation().getPath().isDone())) {
            BasicAirHandler handler = this.drone.getAirHandler();
            boolean bl = this.isExecuting = handler.getPressure() < 9.9f && this.curCharger.getPressure() > handler.getPressure() + 0.1f;
            if (this.isExecuting) {
                ++this.chargingTime;
                if (this.chargingTime > 20) {
                    this.drone.getPathNavigator().moveToXYZ((double)this.curCharger.getBlockPos().getX() + 0.5, (double)this.curCharger.getBlockPos().getY() + 1.5, (double)this.curCharger.getBlockPos().getZ() + 0.5);
                    if (this.drone.getNavigation().getPath() == null || this.drone.getNavigation().getPath().isDone()) {
                        this.drone.setStandby(true, false);
                    } else {
                        this.chargingTime = 0;
                    }
                }
                DroneClaimManager.getInstance(this.drone.level()).claim(this.curCharger.getBlockPos());
            }
            return this.isExecuting;
        }
        this.chargingTime = 0;
        DroneClaimManager.getInstance(this.drone.level()).claim(this.curCharger.getBlockPos());
        return this.drone.isAccelerating();
    }
}

