/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIEditSign;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISignEditWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetEditSign
extends ProgWidgetAreaItemBase
implements ISignEditWidget {
    public static final MapCodec<ProgWidgetEditSign> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetEditSign.baseParts(builder).and((App)Codec.BOOL.optionalFieldOf("back_side", (Object)false).forGetter(ProgWidgetEditSign::isSignBackSide)).apply((Applicative)builder, ProgWidgetEditSign::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetEditSign> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetEditSign::isSignBackSide, ProgWidgetEditSign::new);
    private boolean backSide;

    public ProgWidgetEditSign(ProgWidget.PositionFields pos, boolean backSide) {
        super(pos);
        this.backSide = backSide;
    }

    public ProgWidgetEditSign() {
        super(ProgWidget.PositionFields.DEFAULT);
        this.backSide = false;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetEditSign(this.getPosition(), this.isSignBackSide());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_EDIT_SIGN;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.EDIT_SIGN.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIEditSign(drone, (ProgWidgetAreaItemBase)widget);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    public String[] getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        ProgWidgetText textWidget = (ProgWidgetText)this.getConnectedParameters()[1];
        while (textWidget != null) {
            lines.add(new TextVariableParser(textWidget.string, this.aiManager).parse());
            textWidget = (ProgWidgetText)textWidget.getConnectedParameters()[0];
        }
        return lines.toArray(new String[0]);
    }

    @Override
    public boolean canSetParameter(int index) {
        return index != 3;
    }

    @Override
    public boolean isSignBackSide() {
        return this.backSide;
    }

    @Override
    public void setSignBackSide(boolean backSide) {
        this.backSide = backSide;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetEditSign that = (ProgWidgetEditSign)o;
        return this.baseEquals(that) && this.backSide == that.backSide;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.backSide);
    }
}

